/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.licensemanager;

import com.orocube.licensemanager.LicenseMode;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class OroLicense {
    private String terminalKey;
    private String holderName;
    private String holderEmail;
    private String issuer;
    private String productName;
    private String productVersion;
    private Date issueDate;
    private Date expiryDate;
    private boolean valid;
    private LicenseMode licenseMode = LicenseMode.TERMINAL_BASED;

    public String getTerminalKey() {
        return this.terminalKey;
    }

    public void setTerminalKey(String productKey) {
        this.terminalKey = productKey;
    }

    public String getHolderName() {
        return this.holderName;
    }

    public void setHolderName(String holder) {
        this.holderName = holder;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getHolderEmail() {
        return this.holderEmail;
    }

    public void setHolderEmail(String holderEmail) {
        this.holderEmail = holderEmail;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public boolean isValidForProduct(String productName) {
        return StringUtils.equals((String)productName, (String)this.productName);
    }

    public boolean isValidForProduct(String productName, String version) {
        if (!StringUtils.equals((String)productName, (String)this.productName)) {
            return false;
        }
        return StringUtils.equals((String)this.getMajorVersion(version), (String)this.getMajorVersion(this.productVersion));
    }

    public boolean isValidForTerminal(String userTerminalKey) {
        return userTerminalKey.equals(this.terminalKey);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public LicenseMode getLicenseMode() {
        return this.licenseMode;
    }

    public void setLicenseMode(LicenseMode licenseMode) {
        this.licenseMode = licenseMode;
    }

    private String getMajorVersion(String version) {
        String[] split = version.split("\\.");
        String majorVersion = split[0];
        if (split.length > 1) {
            majorVersion = majorVersion + "." + split[1];
        }
        return majorVersion;
    }
}

