/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.licensemanager.ui;

import com.orocube.licensemanager.ui.LicenseSelectionListener;
import com.orocube.licensemanager.ui.PluginFileChooser;
import com.orocube.licensemanager.ui.PluginMessageDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class InvalidPluginDialog
extends JDialog {
    private Component parent;

    public static void show(LicenseSelectionListener listener, Component parent, String message, String title, String productName, String productVersion, String posTerminalKey) {
        InvalidPluginDialog dialog = new InvalidPluginDialog(listener, parent, message, title, productName, productVersion, posTerminalKey);
        dialog.setMinimumSize(new Dimension(400, 0));
        dialog.setVisible(true);
    }

    public InvalidPluginDialog(final LicenseSelectionListener listener, final Component parent, String message, String title, String productName, String productVersion, String posTerminalKey) throws HeadlessException {
        super((JFrame)parent);
        this.setSize(400, 310);
        JFrame parentC = (JFrame)parent;
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setTitle(title);
        Image applicationImage = parentC.getIconImage();
        this.setIconImage(applicationImage);
        JPanel container = new JPanel(new BorderLayout());
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("fillx,inset 10"));
        JLabel l = new JLabel("Install Plugins");
        l.setFont(new Font(l.getFont().getName(), 1, 24));
        l.setOpaque(true);
        contentPanel.add((Component)l, "h 40!,grow,center,wrap");
        JSeparator sep = new JSeparator();
        contentPanel.add((Component)sep, "grow,span");
        JLabel lblMsg = new JLabel(message);
        lblMsg.setForeground(Color.BLUE);
        contentPanel.add((Component)lblMsg, "center,wrap");
        JLabel lblProductName = new JLabel("<html><h2>" + productName + "</h2></html>");
        contentPanel.add((Component)lblProductName, "wrap");
        JLabel lblCopyright = new JLabel("Copyright \u00a9 Orocube LLC");
        contentPanel.add((Component)lblCopyright, "wrap");
        JLabel lblVersion = new JLabel("Version " + productVersion);
        contentPanel.add((Component)lblVersion, "wrap");
        JTextField tfTerminalKey = new JTextField();
        tfTerminalKey.setHorizontalAlignment(0);
        tfTerminalKey.setText(posTerminalKey);
        tfTerminalKey.setEditable(false);
        tfTerminalKey.setBorder(null);
        contentPanel.add((Component)new JLabel("Terminal key:"), "split 2");
        contentPanel.add((Component)tfTerminalKey, "wrap");
        container.add(contentPanel);
        JButton btnOk = new JButton("Activate with License file");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File pluginFile = PluginFileChooser.selectPluginFile(parent);
                if (pluginFile == null) {
                    return;
                }
                try {
                    listener.licenseFileSelected(pluginFile);
                    PluginMessageDialog.show(parent, listener, null, "Plugin Install", false);
                }
                catch (Exception ex) {
                    PluginMessageDialog.show(parent, listener, ex.getMessage(), "Plugin Install", true);
                }
                InvalidPluginDialog.this.dispose();
            }
        });
        JButton btnCancel = new JButton("Continue with default");
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvalidPluginDialog.this.dispose();
            }
        });
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fillx,right"));
        buttonPanel.add((Component)btnOk, "h 40!,split 2");
        buttonPanel.add((Component)btnCancel, "h 40!");
        contentPanel.add((Component)buttonPanel, "right");
        this.setContentPane(container);
    }

    @Override
    public void setVisible(boolean b) {
        this.setLocationRelativeTo((JFrame)this.parent);
        super.setVisible(b);
    }
}

