/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.licensemanager.ui;

import com.orocube.licensemanager.ui.LicenseSelectionListener;
import com.orocube.licensemanager.ui.PluginFileChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class PluginMessageDialog
extends JDialog {
    private Component parent;

    public static void show(Component parent, LicenseSelectionListener listener, String message, String title, boolean error) {
        PluginMessageDialog dialog = new PluginMessageDialog(parent, listener, message, title, error);
        dialog.setMinimumSize(new Dimension(400, 0));
        dialog.setSize(new Dimension(500, 180));
        dialog.setVisible(true);
    }

    public PluginMessageDialog(final Component parent, final LicenseSelectionListener listener, String message, String title, boolean error) throws HeadlessException {
        super((JFrame)parent);
        JFrame parentC = (JFrame)parent;
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setTitle(title);
        Image applicationImage = null;
        if (parentC != null) {
            applicationImage = parentC.getIconImage();
            this.setIconImage(applicationImage);
        }
        JPanel container = new JPanel(new BorderLayout());
        container.setBorder(new EmptyBorder(5, 10, 5, 10));
        JPanel contentPanel = new JPanel((LayoutManager)new MigLayout("inset 5,fillx,wrap 1,hidemode 3"));
        JLabel l = new JLabel();
        l.setFont(new Font(l.getFont().getName(), 1, 15));
        if (error) {
            l.setText("Invalid license");
            l.setForeground(Color.RED);
        } else {
            l.setText("Installation Sucessfully Complete");
        }
        contentPanel.add(l);
        JLabel lblMsg = new JLabel(error ? "<html>" + message + "</html>" : "<html>You will need to restart pos for the plugin installation changes to take effect. You may try to apply the changes without restarting,but this may cause errors.</html>");
        contentPanel.add(lblMsg);
        container.add(contentPanel);
        JButton btnRestartNow = new JButton("Restart Now");
        btnRestartNow.setVisible(!error);
        btnRestartNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginMessageDialog.this.dispose();
                listener.restartPOS(true);
            }
        });
        JButton btnNotNow = new JButton(error ? "Cancel" : "Not Now");
        btnNotNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginMessageDialog.this.dispose();
            }
        });
        JButton btnTryAgain = new JButton("Try Again");
        btnTryAgain.setVisible(error);
        btnTryAgain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginMessageDialog.this.dispose();
                File pluginFile = PluginFileChooser.selectPluginFile(parent);
                if (pluginFile == null) {
                    return;
                }
                try {
                    listener.licenseFileSelected(pluginFile);
                    PluginMessageDialog.show(parent, listener, null, "Plugin Install", false);
                }
                catch (Exception ex) {
                    PluginMessageDialog.show(parent, listener, ex.getMessage(), "Plugin Install", true);
                }
            }
        });
        JButton btnBuyNow = new JButton("Buy Now");
        btnBuyNow.setVisible(false);
        btnBuyNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PluginMessageDialog.this.openBrowser("https://team.orocube.net:8080/lm");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("right,hidemode 3"));
        buttonPanel.add((Component)btnBuyNow, "h 40!");
        buttonPanel.add((Component)btnTryAgain, "h 40!");
        buttonPanel.add((Component)btnRestartNow, "h 40!");
        buttonPanel.add((Component)btnNotNow, "h 40!");
        container.add((Component)buttonPanel, "South");
        this.setContentPane(container);
    }

    @Override
    public void setVisible(boolean b) {
        this.setLocationRelativeTo((JFrame)this.parent);
        super.setVisible(b);
    }

    private void openBrowser(String link) throws Exception {
        URI uri = new URI(link);
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(uri);
        }
    }
}

