/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.licensemanager;

import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.InvalidProductException;
import com.orocube.licensemanager.InvalidTerminalException;
import com.orocube.licensemanager.LicenseExpiredException;
import com.orocube.licensemanager.LicenseMode;
import com.orocube.licensemanager.LicenseNotFoundException;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.OroLicenseProvider;
import com.orocube.licensemanager.OroPasswordProvider;
import com.orocube.licensemanager.OroPublicKeyDataProvider;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import net.nicholaswilliams.java.licensing.License;
import net.nicholaswilliams.java.licensing.LicenseManager;
import net.nicholaswilliams.java.licensing.LicenseManagerProperties;
import net.nicholaswilliams.java.licensing.LicenseProvider;
import net.nicholaswilliams.java.licensing.encryption.PasswordProvider;
import net.nicholaswilliams.java.licensing.encryption.PublicKeyDataProvider;
import net.nicholaswilliams.java.licensing.immutable.ImmutableLinkedHashSet;
import org.apache.commons.io.FileUtils;

public class LicenseUtil {
    private static final File a = new File(System.getProperty("user.home") + "/.orocube");

    private static File a(String string) {
        File file = new File(".");
        File file2 = new File(file, string + ".lic");
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    private static File b(String string) {
        File file = new File(a, string + ".lic");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static OroLicense loadAndValidate(String string, String string2, String string3) throws InvalidLicenseException, Exception {
        File file = LicenseUtil.a(string);
        if (file == null) {
            file = LicenseUtil.b(string);
        }
        if (file == null || !file.exists()) {
            throw new LicenseNotFoundException(String.format("%s license not found. Please activate %s to continue.", string, string));
        }
        OroLicense oroLicense = LicenseUtil.loadLicense(file);
        LicenseUtil.validateLicense(oroLicense, string, string2, string3);
        return oroLicense;
    }

    public static OroLicense loadAndValidate(File file, String string, String string2, String string3) throws InvalidLicenseException, LicenseNotFoundException, Exception {
        OroLicense oroLicense = LicenseUtil.loadLicense(file);
        LicenseUtil.validateLicense(oroLicense, string, string2, string3);
        return oroLicense;
    }

    public static void validateLicense(OroLicense oroLicense, String string, String string2, String string3) throws InvalidLicenseException {
        oroLicense.setValid(false);
        if (!oroLicense.isValidForProduct(string, string2)) {
            String string4 = "<h2>Invalid license.<br>Found license is valid for " + oroLicense.getProductName() + ".<br>License is needed for " + string + "</h2>";
            InvalidProductException invalidProductException = new InvalidProductException(string4);
            invalidProductException.setLicense(oroLicense);
            throw invalidProductException;
        }
        if (oroLicense.getLicenseMode() == LicenseMode.TERMINAL_BASED && !oroLicense.isValidForTerminal(string3)) {
            String string5 = "License is not valid for this terminal.<br><br>License is registered for terminal with key " + oroLicense.getTerminalKey() + " that does not match with this terminal key.";
            InvalidTerminalException invalidTerminalException = new InvalidTerminalException(string5);
            invalidTerminalException.setLicense(oroLicense);
            throw invalidTerminalException;
        }
        Date date = new Date();
        if (date.after(oroLicense.getExpiryDate())) {
            String string6 = string + " license expired on " + SimpleDateFormat.getDateInstance().format(oroLicense.getExpiryDate()) + ". You need to reactivate " + string + ".";
            LicenseExpiredException licenseExpiredException = new LicenseExpiredException(string6);
            licenseExpiredException.setLicense(oroLicense);
            throw licenseExpiredException;
        }
        oroLicense.setValid(true);
    }

    public static void copyLicenseFile(String string, File file) throws IOException {
        LicenseUtil.copyLicenseFile(file, string);
    }

    public static void copyLicenseFile(File file, String string) throws IOException {
        File file2 = LicenseUtil.a(string);
        if (file2 != null) {
            file2.delete();
        }
        File file3 = new File(a, string + ".lic");
        FileUtils.copyFile((File)file, (File)file3);
    }

    public static OroLicense loadLicense(File file) throws Exception {
        OroLicense oroLicense = new OroLicense();
        if (!file.exists()) {
            return oroLicense;
        }
        LicenseManagerProperties.setPublicKeyDataProvider((PublicKeyDataProvider)new OroPublicKeyDataProvider());
        LicenseManagerProperties.setPublicKeyPasswordProvider((PasswordProvider)new OroPasswordProvider());
        OroLicenseProvider oroLicenseProvider = new OroLicenseProvider(file);
        LicenseManagerProperties.setLicenseProvider((LicenseProvider)oroLicenseProvider);
        LicenseManager licenseManager = LicenseManager.getInstance();
        License license = licenseManager.decryptAndVerifyLicense(oroLicenseProvider.getLicense(""));
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(license.getHolder()));
        JsonObject jsonObject = jsonReader.readObject();
        oroLicense.setHolderName(jsonObject.getString("name"));
        oroLicense.setHolderEmail(jsonObject.getString("email"));
        if (jsonObject.containsKey((Object)"demoLicense")) {
            oroLicense.setDemoLicense(jsonObject.getBoolean("demoLicense"));
        }
        JsonReader jsonReader2 = Json.createReader((Reader)new StringReader(license.getSubject()));
        JsonObject jsonObject2 = jsonReader2.readObject();
        oroLicense.setProductName(jsonObject2.getString("name"));
        oroLicense.setProductVersion(jsonObject2.getString("version"));
        oroLicense.setIssueDate(new Date(license.getIssueDate()));
        oroLicense.setExpiryDate(new Date(license.getGoodBeforeDate()));
        oroLicense.setIssuer(license.getIssuer());
        String string = license.getProductKey();
        oroLicense.setTerminalKey(string);
        ImmutableLinkedHashSet immutableLinkedHashSet = license.getFeatures();
        for (License.Feature feature : immutableLinkedHashSet) {
            String string2 = feature.getName();
            if (string2 != null && string2.startsWith("licenseMode:")) {
                String string3 = string2.split(":")[1].trim();
                LicenseMode licenseMode = LicenseMode.valueOf(string3);
                oroLicense.setLicenseMode(licenseMode);
                continue;
            }
            oroLicense.addFeature(string2);
        }
        return oroLicense;
    }
}

