/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.licensemanager.ui;

import com.orocube.licensemanager.ui.LicenseSelectionListener;
import com.orocube.licensemanager.ui.PluginFileChooser;
import com.orocube.licensemanager.ui.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class PluginMessageDialog
extends JDialog {
    private Component a;

    public static void show(Component component, LicenseSelectionListener licenseSelectionListener, String string, String string2, boolean bl) {
        PluginMessageDialog pluginMessageDialog = new PluginMessageDialog(component, licenseSelectionListener, string, string2, bl);
        pluginMessageDialog.setMinimumSize(new Dimension(600, 400));
        pluginMessageDialog.pack();
        pluginMessageDialog.setVisible(true);
    }

    public PluginMessageDialog(final Component component, final LicenseSelectionListener licenseSelectionListener, String string, String string2, boolean bl) throws HeadlessException {
        super(Util.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        JFrame jFrame = (JFrame)component;
        this.setLayout(new BorderLayout());
        this.setModal(true);
        this.setTitle(string2);
        Image image = null;
        if (jFrame != null) {
            image = jFrame.getIconImage();
            this.setIconImage(image);
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("inset 5,fillx,wrap 1,hidemode 3"));
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font(jLabel.getFont().getName(), 1, 15));
        if (bl) {
            jLabel.setText("Invalid license");
            jLabel.setForeground(Color.RED);
        } else {
            jLabel.setText("Installation Sucessfully Complete");
        }
        jPanel2.add(jLabel);
        JLabel jLabel2 = new JLabel(bl ? "<html>" + string + "</html>" : "<html>You will need to restart pos for the plugin installation changes to take effect. You may try to apply the changes without restarting,but this may cause errors.</html>");
        jPanel2.add(jLabel2);
        jPanel.add(jPanel2);
        JButton jButton = new JButton("Restart Now");
        jButton.setVisible(!bl);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginMessageDialog.this.dispose();
                licenseSelectionListener.restartPOS(true);
            }
        });
        JButton jButton2 = new JButton(bl ? "Cancel" : "Not Now");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginMessageDialog.this.dispose();
            }
        });
        JButton jButton3 = new JButton("Try Again");
        jButton3.setVisible(bl);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PluginMessageDialog.this.dispose();
                File file = PluginFileChooser.selectPluginFile(component);
                if (file == null) {
                    return;
                }
                try {
                    licenseSelectionListener.licenseFileSelected(file);
                    PluginMessageDialog.show(component, licenseSelectionListener, null, "Plugin Install", false);
                }
                catch (Exception exception) {
                    PluginMessageDialog.show(component, licenseSelectionListener, exception.getMessage(), "Plugin Install", true);
                }
            }
        });
        JButton jButton4 = new JButton("Buy Now");
        jButton4.setVisible(false);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PluginMessageDialog.this.a("https://team.orocube.net:8080/lm");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("right,hidemode 3"));
        jPanel3.add((Component)jButton4, "h 40!");
        jPanel3.add((Component)jButton3, "h 40!");
        jPanel3.add((Component)jButton, "h 40!");
        jPanel3.add((Component)jButton2, "h 40!");
        jPanel.add((Component)jPanel3, "South");
        this.setContentPane(jPanel);
    }

    @Override
    public void setVisible(boolean bl) {
        this.setLocationRelativeTo((JFrame)this.a);
        super.setVisible(bl);
    }

    private void a(String string) throws Exception {
        URI uRI = new URI(string);
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(uRI);
        }
    }
}

