package com.floreantpos.model;

public class CategoryBreakOut {

	public final static String GROSS_SALES = "grossSales"; //$NON-NLS-1$
	public final static String TAX_INCLUDED_AMOUNT = "taxIncludedAmount"; //$NON-NLS-1$
	public final static String DISCOUNT_AMOUNT = "discountAmount"; //$NON-NLS-1$
	public final static String RETURN_AMOUNT = "returnAmount"; //$NON-NLS-1$

	protected String categoryId;
	protected String categoryName;
	protected Double grossSales;
	protected Double taxIncludedAmount;
	protected Double discountAmount;
	protected Double returnAmount;

	protected Double breakOutAmt;

	public CategoryBreakOut() {
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public Double getGrossSales() {
		return grossSales == null ? Double.valueOf(0) : grossSales;
	}

	public void setGrossSales(Double grossSales) {
		this.grossSales = grossSales;
	}

	public Double getTaxIncludedAmount() {
		return taxIncludedAmount == null ? Double.valueOf(0) : taxIncludedAmount;
	}

	public void setTaxIncludedAmount(Double taxIncludedAmount) {
		this.taxIncludedAmount = taxIncludedAmount;
	}

	public Double getDiscountAmount() {
		return discountAmount == null ? Double.valueOf(0) : discountAmount;
	}

	public void setDiscountAmount(Double discountAmount) {
		this.discountAmount = discountAmount;
	}

	public Double getReturnAmount() {
		return returnAmount == null ? Double.valueOf(0) : returnAmount;
	}

	public void setReturnAmount(Double returnAmount) {
		this.returnAmount = returnAmount;
	}

	public Double getBreakOutAmt() {
		return breakOutAmt;
	}

	public void setBreakOutAmt(Double breakOutAmt) {
		this.breakOutAmt = breakOutAmt;
	}

	public String getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(String categoryId) {
		this.categoryId = categoryId;
	}

	public void calculateBreakoutAmount() {
		breakOutAmt = getGrossSales() - getTaxIncludedAmount() - getDiscountAmount() + getReturnAmount();
	}

}
