package com.floreantpos.model;

import java.util.Date;

import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.floreantpos.model.base.BaseLedgerEntry;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class LedgerEntry extends BaseLedgerEntry implements PropertyContainer2 {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public LedgerEntry() {
	}

	/**
	 * Constructor for primary key
	 */
	public LedgerEntry(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void setChartOfAccountDisplay() {

	}

	public String getChartOfAccountDisplay() {
		String cOAccountId = getAccountId();
		if (StringUtils.isBlank(cOAccountId)) {
			return "";
		}
		ChartOfAccounts chartOfAccounts = (ChartOfAccounts) DataProvider.get().getObjectOf(ChartOfAccounts.class, cOAccountId);
		if (chartOfAccounts == null) {
			return "";
		}
		return chartOfAccounts.getCoaAccountTypeName() + " -> " + chartOfAccounts.getName();
	}

	public double getCreditDirectionDisplay() {
		Integer direction = getDirection();
		if (DirectionType.DEBIT.getTypeNo() == direction) {
			return 0d;
		}
		return getAmount();
	}

	public double getDebitDirectionDisplay() {
		Integer direction = getDirection();
		if (DirectionType.CREDIT.getTypeNo() == direction) {
			return 0d;
		}
		return getAmount();
	}

	public String getDateDisplay() {
		String dateAsString = ""; //$NON-NLS-1$
		Date lastUpdateTime = getCreateDate();
		if (lastUpdateTime == null) {
			return dateAsString;
		}
		//return DateUtil.formatAsShortDate(lastUpdateTime);
		return DateUtil.formatDateWithBrowserTimeOffsetWithoutSec(lastUpdateTime);
	}

	public static LedgerEntry createLedgerEntry(Ticket ticket, ChartOfAccounts chartOfAccounts, DirectionType directionType, double remainLedgerAmount,
			String description, Date createDate) {
		LedgerEntry ledgerEntry = new LedgerEntry();
		ledgerEntry.setCreateDate(createDate);
		ledgerEntry.setDescription(description);
		ledgerEntry.setAccountId(chartOfAccounts.getId());
		User currentUser = DataProvider.get().getCurrentUser();
		if (currentUser != null) {
			ledgerEntry.setUserId(currentUser.getId());
		}
		if (ticket != null) {
			ledgerEntry.setTicketId(ticket.getId());
			//ledgerEntry.setPatientId(ticket.getCustomerId());
			ledgerEntry.setRecepientId(ticket.getCustomerId());
			ledgerEntry.setDoctorId(ticket.getDoctorId());
			ledgerEntry.setAgentId(ticket.getReferrerId());
		}
		ledgerEntry.setAmount(Math.abs(remainLedgerAmount));
		int typeNo = remainLedgerAmount < 0 ? (-1) * directionType.getTypeNo() : directionType.getTypeNo();
		ledgerEntry.setDirection(typeNo);
		return ledgerEntry;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

//	public void putLedgerEntryType(String ledgerEntryTypeName) {
//		addProperty("ledger.entry.type", ledgerEntryTypeName); //$NON-NLS-1$
//	}
//	
//	@XmlTransient
//	@JsonIgnore
//	public String getLedgerEntryType() {
//		String ledgerEntryTypeName = getProperty("ledger.entry.type");
//		if (StringUtils.isBlank(ledgerEntryTypeName)) {
//			return "";
//		}
//		return ledgerEntryTypeName;
//	}

}