package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DataProvider;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "member" })
@XmlAccessorType(XmlAccessType.FIELD)
public class TicketItemSeat extends BaseTicketItemSeat {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TicketItemSeat() {
	}

	/**
	 * Constructor for primary key
	 */
	public TicketItemSeat(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	private ShopSeat shopSeat;
	private Customer member;

	public void setShopSeat(ShopSeat shopSeat) {
		this.shopSeat = shopSeat;
		setSeatId(shopSeat == null ? null : shopSeat.getId());
		setSeatNumber(shopSeat == null ? null : shopSeat.getSeatNumber());
	}

	public ShopSeat getShopSeat() {
		if (shopSeat != null) {
			return shopSeat;
		}
		if (getSeatId() != null) {
			shopSeat = (ShopSeat) DataProvider.get().getObjectOf(ShopSeat.class, getSeatId());
		}
		return shopSeat;
	}

	public void setMember(Customer member) {
		this.member = member;
		setMemberId(member == null ? null : member.getId());
	}

	@XmlTransient
	public Customer getMember() {
		String customerId = getMemberId();
		if (StringUtils.isEmpty(customerId)) {
			return null;
		}
		if (this.member != null && member.getId().equals(customerId)) {
			return this.member;
		}
		member = CustomerDAO.getInstance().get(customerId);
		return member;
	}

}