package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the MENU_ITEM_MODIFIER_PAGE_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MENU_ITEM_MODIFIER_PAGE_ITEM"
 */

public abstract class BaseMenuItemModifierPageItem  implements Comparable, Serializable {

	public static String REF = "MenuItemModifierPageItem"; //$NON-NLS-1$
	public static String PROP_IMAGE_ID = "imageId"; //$NON-NLS-1$
	public static String PROP_MENU_MODIFIER_ID = "menuModifierId"; //$NON-NLS-1$
	public static String PROP_MENU_MODIFIER_NAME = "menuModifierName"; //$NON-NLS-1$
	public static String PROP_SHOW_IMAGE_ONLY = "showImageOnly"; //$NON-NLS-1$
	public static String PROP_SORT_ORDER = "sortOrder"; //$NON-NLS-1$
	public static String PROP_PARENT_PAGE_ID = "parentPageId"; //$NON-NLS-1$
	public static String PROP_HEIGHT = "height"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_TEXT_COLOR_CODE = "textColorCode"; //$NON-NLS-1$
	public static String PROP_COL = "col"; //$NON-NLS-1$
	public static String PROP_ROW = "row"; //$NON-NLS-1$
	public static String PROP_BUTTON_COLOR_CODE = "buttonColorCode"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_WIDTH = "width"; //$NON-NLS-1$
	public static String PROP_TRANSLATED_NAME = "translatedName"; //$NON-NLS-1$


	// constructors
	public BaseMenuItemModifierPageItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMenuItemModifierPageItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Integer col;
				private java.lang.Integer row;
				private java.lang.Integer width;
				private java.lang.Integer height;
				private java.lang.String menuModifierId;
				private java.lang.String menuModifierName;
				private java.lang.String translatedName;
				private java.lang.Integer sortOrder;
				private java.lang.Integer buttonColorCode;
				private java.lang.Integer textColorCode;
				private java.lang.String imageId;
				private java.lang.Boolean showImageOnly;
				private java.lang.String parentPageId;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: COL
	 */

	public java.lang.Integer getCol () {
						return col == null ? Integer.valueOf(0) : col;
		}



	/**
	 * Set the value related to the column: COL
	 * @param col the COL value
	 */
			public void setCol (java.lang.Integer col) {
			this.col = col;
	}



	/**
	 * Return the value associated with the column: ROW
	 */

	public java.lang.Integer getRow () {
						return row == null ? Integer.valueOf(0) : row;
		}



	/**
	 * Set the value related to the column: ROW
	 * @param row the ROW value
	 */
			public void setRow (java.lang.Integer row) {
			this.row = row;
	}



	/**
	 * Return the value associated with the column: WIDTH
	 */

	public java.lang.Integer getWidth () {
						return width == null ? Integer.valueOf(0) : width;
		}



	/**
	 * Set the value related to the column: WIDTH
	 * @param width the WIDTH value
	 */
			public void setWidth (java.lang.Integer width) {
			this.width = width;
	}



	/**
	 * Return the value associated with the column: HEIGHT
	 */

	public java.lang.Integer getHeight () {
						return height == null ? Integer.valueOf(0) : height;
		}



	/**
	 * Set the value related to the column: HEIGHT
	 * @param height the HEIGHT value
	 */
			public void setHeight (java.lang.Integer height) {
			this.height = height;
	}



	/**
	 * Return the value associated with the column: MENU_MODIFIER_ID
	 */

	public java.lang.String getMenuModifierId () {
			return menuModifierId;
	}



	/**
	 * Set the value related to the column: MENU_MODIFIER_ID
	 * @param menuModifierId the MENU_MODIFIER_ID value
	 */
			public void setMenuModifierId (java.lang.String menuModifierId) {
			this.menuModifierId = menuModifierId;
	}



	/**
	 * Return the value associated with the column: MENU_MODIFIER_NAME
	 */

	public java.lang.String getMenuModifierName () {
			return menuModifierName;
	}



	/**
	 * Set the value related to the column: MENU_MODIFIER_NAME
	 * @param menuModifierName the MENU_MODIFIER_NAME value
	 */
			public void setMenuModifierName (java.lang.String menuModifierName) {
			this.menuModifierName = menuModifierName;
	}



	/**
	 * Return the value associated with the column: TRANSLATED_NAME
	 */

	public java.lang.String getTranslatedName () {
			return translatedName;
	}



	/**
	 * Set the value related to the column: TRANSLATED_NAME
	 * @param translatedName the TRANSLATED_NAME value
	 */
			public void setTranslatedName (java.lang.String translatedName) {
			this.translatedName = translatedName;
	}



	/**
	 * Return the value associated with the column: SORT_ORDER
	 */

	public java.lang.Integer getSortOrder () {
						return sortOrder == null ? Integer.valueOf(0) : sortOrder;
		}



	/**
	 * Set the value related to the column: SORT_ORDER
	 * @param sortOrder the SORT_ORDER value
	 */
			public void setSortOrder (java.lang.Integer sortOrder) {
			this.sortOrder = sortOrder;
	}



	/**
	 * Return the value associated with the column: BTN_COLOR
	 */

	public java.lang.Integer getButtonColorCode () {
						return buttonColorCode == null ? null : buttonColorCode;
			}



	/**
	 * Set the value related to the column: BTN_COLOR
	 * @param buttonColorCode the BTN_COLOR value
	 */
			public void setButtonColorCode (java.lang.Integer buttonColorCode) {
			this.buttonColorCode = buttonColorCode;
	}


	/**
	 * Custom property
	 */
	public static String getButtonColorCodeDefaultValue () {
		return "null";
	}


	/**
	 * Return the value associated with the column: TEXT_COLOR
	 */

	public java.lang.Integer getTextColorCode () {
						return textColorCode == null ? null : textColorCode;
			}



	/**
	 * Set the value related to the column: TEXT_COLOR
	 * @param textColorCode the TEXT_COLOR value
	 */
			public void setTextColorCode (java.lang.Integer textColorCode) {
			this.textColorCode = textColorCode;
	}


	/**
	 * Custom property
	 */
	public static String getTextColorCodeDefaultValue () {
		return "null";
	}


	/**
	 * Return the value associated with the column: IMAGE_ID
	 */

	public java.lang.String getImageId () {
			return imageId;
	}



	/**
	 * Set the value related to the column: IMAGE_ID
	 * @param imageId the IMAGE_ID value
	 */
			public void setImageId (java.lang.String imageId) {
			this.imageId = imageId;
	}



	/**
	 * Return the value associated with the column: SHOW_IMAGE_ONLY
	 */

	public java.lang.Boolean isShowImageOnly () {
					return showImageOnly == null ? Boolean.FALSE : showImageOnly;
		}

	public java.lang.Boolean getShowImageOnly () {
				return showImageOnly == null ? Boolean.FALSE : showImageOnly;
			}


	/**
	 * Set the value related to the column: SHOW_IMAGE_ONLY
	 * @param showImageOnly the SHOW_IMAGE_ONLY value
	 */
			public void setShowImageOnly (java.lang.Boolean showImageOnly) {
			this.showImageOnly = showImageOnly;
	}



	/**
	 * Return the value associated with the column: PAGE_ID
	 */

	public java.lang.String getParentPageId () {
			return parentPageId;
	}



	/**
	 * Set the value related to the column: PAGE_ID
	 * @param parentPageId the PAGE_ID value
	 */
			public void setParentPageId (java.lang.String parentPageId) {
			this.parentPageId = parentPageId;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MenuItemModifierPageItem)) return false;
		else {
			com.floreantpos.model.MenuItemModifierPageItem menuItemModifierPageItem = (com.floreantpos.model.MenuItemModifierPageItem) obj;
			if (null == this.getId() || null == menuItemModifierPageItem.getId()) return this == obj;
			else return (this.getId().equals(menuItemModifierPageItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}