package com.floreantpos.model.dao;

import java.util.Date;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.RfPayTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.FeePaymentMapper;

public class RfPayTransactionDAO extends BaseRfPayTransactionDAO {

	public RfPayTransactionDAO() {
	}

	public RfPayTransaction createRfPayTransaction(FeePaymentMapper rfPaymentMapper, Session session) throws Exception {
		if (rfPaymentMapper.getReferrer() == null) {
			return null;
		}

		StoreSession storeSession = DataProvider.get().getStoreSession();
		if (storeSession == null && rfPaymentMapper.getCashDrawer() != null) {
			storeSession = rfPaymentMapper.getCashDrawer().getStoreSession();
		}

		RfPayTransaction rfPayTransaction = new RfPayTransaction();

		double payoutAmount = rfPaymentMapper.getPayoutAmount();
		double tenderAmount = rfPaymentMapper.getTenderAmount();
		User currentUser = rfPaymentMapper.getUser();
		CustomPayment customPayment = rfPaymentMapper.getCustomPayment();
		if (customPayment != null) {
			rfPayTransaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
			rfPayTransaction.setCustomPaymentId(customPayment.getId());
			rfPayTransaction.setCustomPaymentRef(rfPaymentMapper.getCustomPaymnetRef());
			rfPayTransaction.setCustomPaymentName(customPayment.getName());
		}
		else {
			rfPayTransaction.setPaymentType(PaymentType.CASH);
		}
		rfPayTransaction.setTransactionType(TransactionType.OUT.name());
		rfPayTransaction.setAmount(payoutAmount);
		rfPayTransaction.setTenderAmount(tenderAmount);
		if (tenderAmount > payoutAmount) {
			rfPayTransaction.setChangeAmount(tenderAmount - payoutAmount);
		}
		rfPayTransaction.setRecepientId(rfPaymentMapper.getReferrer().getId());
		rfPayTransaction.setCashDrawer(rfPaymentMapper.getCashDrawer());
		if (storeSession != null) {
			rfPayTransaction.setStoreSessionId(storeSession.getId());
		}
		rfPayTransaction.setTransTicketIds(rfPaymentMapper.getTicketIds());
		rfPayTransaction.setOutletId(DataProvider.get().getOutletId());
		rfPayTransaction.setUser(currentUser);
		rfPayTransaction.setServer(currentUser);
		rfPayTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
		rfPayTransaction.setTerminal(rfPaymentMapper.getTerminal());

		saveOrUpdate(rfPayTransaction, session);
		return rfPayTransaction;
	}

	public List<RfPayTransaction> findRFPayments(Date fromDate, Date toDate, Customer referrer) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(RfPayTransaction.class);
			criteria.add(Restrictions.eq(RfPayTransaction.PROP_VOIDED, false));

			if (referrer != null) {
				criteria.add(Restrictions.eq(RfPayTransaction.PROP_RECEPIENT_ID, referrer.getId()));
			}
			if (fromDate != null && toDate != null) {
				criteria.add(Restrictions.between(RfPayTransaction.PROP_TRANSACTION_TIME, DateUtil.startOfDay(fromDate), DateUtil.endOfDay(toDate)));
			}
			criteria.addOrder(Order.desc(RfPayTransaction.PROP_TRANSACTION_TIME));
			return criteria.list();
		}
	}
}