package com.floreantpos.report.model;

import com.floreantpos.report.ReferralCommissionReportData;
import com.floreantpos.swing.ListTableModel;

public class ReferralCommissionReportModel extends ListTableModel {
	public ReferralCommissionReportModel() {
		super(new String[] { "referralType", "referralBy", "receivable", "due", "received", "labDoctorFee", "RFonReport", "ofcNet", "RFonNetSales", "RFpayable",
				"RFpaid", "RFdue", "ofcTotal", "orderId", "orderDate", "patientName", "patientMobileNo" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		ReferralCommissionReportData reportData = (ReferralCommissionReportData) rows.get(rowIndex);

		double officeNet = reportData.getReceived() - (reportData.getLabDoctorFee() + reportData.getAgentCommissionOnReport());
		double officeTotal = officeNet - reportData.getAgentCommissionOnNetSales();
		double agentFeeGrossPayable = reportData.getAgentCommissionOnReport() + reportData.getAgentCommissionOnNetSales();

		switch (columnIndex) {
			case 0:
				return reportData.getReferralType();

			case 1:
				return reportData.getReferralBy();

			case 2:
				return reportData.getReceivable();

			case 3:
				return reportData.getDue();

			case 4:
				return reportData.getReceived();

			case 5:
				return reportData.getLabDoctorFee();

			case 6:
				return reportData.getAgentCommissionOnReport();

			case 7:
				return officeNet;

			case 8:
				return reportData.getAgentCommissionOnNetSales();

			case 9:
				return agentFeeGrossPayable;

			case 10:
				return reportData.getReferrerFeePaidAmount();

			case 11:
				return reportData.getReferrerFeeDueAmount();

			case 12:
				return officeTotal;

			case 13:
				return reportData.getOrderId();

			case 14:
				return reportData.getOrderDate();

			case 15:
				return reportData.getPatientName();

			case 16:
				return reportData.getPatientMobileNo();

		}
		return null;
	}

}