package com.floreantpos.model;

import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseDonor;
import com.floreantpos.model.dao.StoreDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class Donor extends BaseDonor implements PropertyContainer2, TimedModel {
	private static final long serialVersionUID = 1L;

	private transient JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Donor() {
		setCreateDate(StoreDAO.getServerTimestamp());
	}

	/**
	 * Constructor for primary key
	 */
	public Donor(java.lang.String id) {
		super(id);
		setCreateDate(StoreDAO.getServerTimestamp());
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	@Override
	public String toString() {
		return getName();
	}

	public String getApproxAge() {
		Date dateOfBirth = getDateOfBirth();
		if (dateOfBirth != null) {
			LocalDate birthdate = dateOfBirth.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
			LocalDate currentDate = LocalDate.now();
			Period agePeriod = Period.between(birthdate, currentDate);
			int years = agePeriod.getYears();
			int months = agePeriod.getMonths();
			int days = agePeriod.getDays();
			if (years > 0) {
				return String.format("%d Y", years);
			}
			if (months > 0) {
				return String.format("%d M", months);
			}

			return String.format("%d days", days);
		}
		return null;
	}

	public String getName() {
		String name = super.getFirstName();
		if (StringUtils.isNotEmpty(super.getLastName())) {
			name += " " + super.getLastName(); //$NON-NLS-1$
		}
		return name;
	}

	public String getOccupation() {
		return getProperty("occupation", StringUtils.EMPTY);
	}

	public void putOccupation(String value) {
		addProperty("occupation", value);
	}

}