package com.floreantpos.model;

import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseMedicationSchedule;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class MedicationSchedule extends BaseMedicationSchedule implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	private transient JsonObject propertiesContainer;
	private transient MenuItem menuItem;
	private transient BookingInfo booking;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public MedicationSchedule() {
		setCreateDate(StoreDAO.getServerTimestamp());
	}

	/**
	 * Constructor for primary key
	 */
	public MedicationSchedule(java.lang.String id) {
		super(id);
		setCreateDate(StoreDAO.getServerTimestamp());
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@XmlTransient
	public MenuItem getMenuItem() {
		if (menuItem == null) {
			String itemId = getItemId();
			if (StringUtils.isEmpty(itemId)) {
				return null;
			}
			menuItem = MenuItemDAO.getInstance().loadInitialized(itemId);
		}

		return menuItem;
	}

	public void setMenuItem(MenuItem menuItem) {
		this.menuItem = menuItem;
		String menuItemId = null;
		if (menuItem != null) {
			menuItemId = menuItem.getId();
		}
		super.setItemId(menuItemId);
	}

	public BookingInfo getBooking() {
		if (booking != null) {
			return booking;
		}
		if (StringUtils.isNotBlank(super.getAdmissionId())) {
			return booking = BookingInfoDAO.getInstance().findByBookingId(super.getAdmissionId());
		}
		return booking;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public String getMedTakingTime() {
		return getProperty("medicine.time", "");
	}

	public void putMedTakingTime(String medTakingTime) {
		addProperty("medicine.time", medTakingTime); //$NON-NLS-1$
	}

	public double getTakingQty() {
		return getDoubleProperty("medicine.quantity");
	}

	public void putTakingQty(double takingQty) {
		addProperty("medicine.quantity", String.valueOf(takingQty)); //$NON-NLS-1$
	}

	public String getTakingQtyUnit() {
		return getProperty("medicine.quantity.unit", "");
	}

	public void putTakingQtyUnit(String takingQtyUnit) {
		addProperty("medicine.quantity.unit", takingQtyUnit); //$NON-NLS-1$
	}

	public String getNote() {
		return getProperty("note", "");
	}

	public void putNote(String note) {
		addProperty("note", note); //$NON-NLS-1$
	}

	public String getCustomName() {
		return getProperty("custom.name", "");
	}

	public void putCustomName(String customName) {
		addProperty("custom.name", customName); //$NON-NLS-1$
	}
	
	public String getActionDescription() {
		return getProperty("action_description", "");
	}
	
	public void putActionDescription(String actionDescription) {
		addProperty("action_description", actionDescription); //$NON-NLS-1$
	}
	
	public String getCancelReason() {
		return getProperty("cancel_reason", "");
	}
	
	public void putCancelReason(String cancelReason) {
		addProperty("cancel_reason", cancelReason); //$NON-NLS-1$
	}

}