package com.floreantpos.model;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.base.BaseNurseVisit;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.GsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

public class NurseVisit extends BaseNurseVisit implements TimedModel, PropertyContainer2, IVisit {
	private static final long serialVersionUID = 1L;

	private transient com.google.gson.JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	private transient Patient patient;
	private transient BookingInfo bookingInfo;
	private transient User nurse;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public NurseVisit() {
	}

	/**
	 * Constructor for primary key
	 */
	public NurseVisit(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public Patient getPatient() {
		if (patient != null) {
			return patient;
		}
		if (StringUtils.isNotBlank(super.getPatientId())) {
			patient = (Patient) DataProvider.get().getObjectOf(Patient.class, super.getPatientId());
		}
		return patient;
	}

	public void setPatient(Patient patient) {
		this.patient = patient;
		super.setPatientId(patient == null ? null : patient.getId());
	}

	public User getNurse() {
		if (nurse != null) {
			return nurse;
		}
		if (StringUtils.isNotBlank(super.getNurseId())) {
			return nurse = DataProvider.get().getUserById(super.getNurseId(), DataProvider.get().getOutletId());
		}
		return nurse;
	}

	public void setNurse(User nurse) {
		this.nurse = nurse;
		super.setNurseId(nurse == null ? null : nurse.getId());
	}

	public BookingInfo getBooking() {
		if (bookingInfo != null) {
			return bookingInfo;
		}
		if (StringUtils.isNotBlank(super.getAdmissionId())) {
			return bookingInfo = BookingInfoDAO.getInstance().findByBookingId(super.getAdmissionId());
		}
		return bookingInfo;
	}

	public void setBooking(BookingInfo bookingInfo) {
		this.bookingInfo = bookingInfo;
		super.setAdmissionId(bookingInfo == null ? null : bookingInfo.getBookingId());
	}

	public String getTemparature() {
		return getProperty("temparature", ""); //$NON-NLS-1$
	}

	public void putTemparature(String temparature) {
		addProperty("temparature", temparature); //$NON-NLS-1$
	}

	public String getPressureUp() {
		return getProperty("pressure.up", ""); //$NON-NLS-1$
	}

	public void putPressureUp(String pressureUp) {
		addProperty("pressure.up", pressureUp); //$NON-NLS-1$
	}

	public String getPressureDown() {
		return getProperty("pressure.down", ""); //$NON-NLS-1$
	}

	public void putPressureDown(String pressureDown) {
		addProperty("pressure.down", pressureDown); //$NON-NLS-1$
	}

	public String getHeartBitPerMinute() {
		return getProperty("heartBitPerMinute", ""); //$NON-NLS-1$
	}

	public void putHeartBitPerMinute(String heartBitPerMinutes) {
		addProperty("heartBitPerMinute", heartBitPerMinutes); //$NON-NLS-1$
	}

	public List<String> getProblems() {
		return GsonUtil.convertJSONToList(getProperty("problems", "[]"), String.class);
	}

	public void putProblems(List<String> problems) {
		addProperty("problems", GsonUtil.createGson().toJson(problems));
	}

	public String getNotes() {
		return getProperty("inspection.notes", StringUtils.EMPTY); //$NON-NLS-1$
	}

	public void putNotes(String notes) {
		addProperty("inspection.notes", notes); //$NON-NLS-1$
	}

	public void putPatientWeight(String heightInCm) {
		addProperty("PatientWeight", heightInCm); //$NON-NLS-1$
	}

	public String getPatientWeight() {
		return getProperty("PatientWeight", ""); //$NON-NLS-1$
	}

	public void putPatientHeightInCm(String heightInCm) {
		addProperty("PatientHeightInCm", heightInCm); //$NON-NLS-1$
	}

	public String getPatientHeightInCm() {
		return getProperty("PatientHeightInCm", ""); //$NON-NLS-1$
	}

}