/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum ProductType {
	//@formatter:off
	PATHOLOGY("Pathology"), 
	GOODS("Goods"), 
	MEDICINE("Medicine"), 
	SERVICES("Services"),
	OT("OT"),
	SURGICAL_EQUIPMENT("Surgical equipment"),
	GENERAL_EQUIPMENT("General equipment")
	;
	//@formatter:on
	private String displayString;

	private ProductType(String displayString) {
		this.displayString = displayString;
	}

	public static ProductType fromString(String s) {
		if (StringUtils.isBlank(s)) {
			return PATHOLOGY;
		}

		try {
			ProductType filter = valueOf(s);
			return filter;
		} catch (Exception e) {
			return PATHOLOGY;
		}
	}

	public String toString() {
		return name().replaceAll("_", " "); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public String getDisplayString() {
		return displayString;
	}

	public static boolean match(String srcProductTypeName, ProductType trgProductType) {
		ProductType srcProductType = ProductType.fromString(srcProductTypeName);
		return trgProductType == srcProductType;
	}
}
