package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the MED_SURGERY_INFO table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MED_SURGERY_INFO"
 */

public abstract class BaseSurgeryInfo  implements Serializable {

	public static String REF = "SurgeryInfo"; //$NON-NLS-1$
	public static String PROP_CONSENT_SIGNED_BY = "consentSignedBy"; //$NON-NLS-1$
	public static String PROP_ADMISSION_ID = "admissionId"; //$NON-NLS-1$
	public static String PROP_BLOOD_GROUP = "bloodGroup"; //$NON-NLS-1$
	public static String PROP_DOCTOR_APPROVAL_SIGNATURE = "doctorApprovalSignature"; //$NON-NLS-1$
	public static String PROP_OT_APPROVAL = "otApproval"; //$NON-NLS-1$
	public static String PROP_SURGERY_ITEM_ID = "surgeryItemId"; //$NON-NLS-1$
	public static String PROP_ANESTHESIOLOGIST_NAME = "anesthesiologistName"; //$NON-NLS-1$
	public static String PROP_APPROVED_BY_ID = "approvedById"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_UNIT = "unit"; //$NON-NLS-1$
	public static String PROP_APPROVED_TIME = "approvedTime"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_SURGERY_PROCEDURE_STATUS = "surgeryProcedureStatus"; //$NON-NLS-1$
	public static String PROP_APPROVAL_STATUS = "approvalStatus"; //$NON-NLS-1$
	public static String PROP_ANESTHESIOLOGIST_ID = "anesthesiologistId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_SURGERY_DIAGNOSIS_ITEMS = "surgeryDiagnosisItems"; //$NON-NLS-1$
	public static String PROP_SURGERY_MEDICINE_ITEMS = "surgeryMedicineItems"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_URGENCY_LEVEL = "urgencyLevel"; //$NON-NLS-1$
	public static String PROP_RELATION_WITH_PATIENT = "relationWithPatient"; //$NON-NLS-1$
	public static String PROP_REQUESTED_DATE = "requestedDate"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_POST_OPERATIVE_SPECIMEN_ID = "postOperativeSpecimenId"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_APPROVED_DATE = "approvedDate"; //$NON-NLS-1$
	public static String PROP_OT_IN_CHARGE_ID = "otInChargeId"; //$NON-NLS-1$
	public static String PROP_QUANTITY = "quantity"; //$NON-NLS-1$
	public static String PROP_ORDER_ID = "orderId"; //$NON-NLS-1$
	public static String PROP_DOCTOR_APPROVAL_DATE = "doctorApprovalDate"; //$NON-NLS-1$
	public static String PROP_CONSENT_SIGNED = "consentSigned"; //$NON-NLS-1$
	public static String PROP_REQUESTED_TIME = "requestedTime"; //$NON-NLS-1$
	public static String PROP_VOLUME = "volume"; //$NON-NLS-1$
	public static String PROP_OT_ROOM_ID = "otRoomId"; //$NON-NLS-1$
	public static String PROP_EXPECTED_SURGERY_DURATION = "expectedSurgeryDuration"; //$NON-NLS-1$
	public static String PROP_BLOOD_REQUIRED = "bloodRequired"; //$NON-NLS-1$
	public static String PROP_OT_BED_ID = "otBedId"; //$NON-NLS-1$
	public static String PROP_OT_IN_CHARGE_SIGNATURE = "otInChargeSignature"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_DOCTOR_APPROVAL = "doctorApproval"; //$NON-NLS-1$
	public static String PROP_SURGERY_STATUS = "surgeryStatus"; //$NON-NLS-1$
	public static String PROP_BLOOD_TYPE = "bloodType"; //$NON-NLS-1$


	// constructors
	public BaseSurgeryInfo () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseSurgeryInfo (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date createDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String outletId;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
				private java.lang.String surgeryStatus;
				private java.lang.String surgeryProcedureStatus;
				private java.lang.String patientId;
				private java.lang.String admissionId;
				private java.lang.String orderId;
				private java.lang.String urgencyLevel;
				private java.lang.String surgeryItemId;
				private java.lang.String surgeryDiagnosisItems;
				private java.lang.String surgeryMedicineItems;
				private java.util.Date requestedDate;
				private java.lang.String requestedTime;
				private int expectedSurgeryDuration;
				private java.lang.Boolean consentSigned;
				private java.lang.String consentSignedBy;
				private java.lang.String relationWithPatient;
				private java.lang.Boolean bloodRequired;
				private java.lang.String bloodGroup;
				private java.lang.String bloodType;
				private java.lang.Integer quantity;
				private java.lang.Double volume;
				private java.lang.String unit;
				private java.lang.Boolean doctorApproval;
				private java.lang.String approvedById;
				private java.util.Date doctorApprovalDate;
				private java.lang.String doctorApprovalSignature;
				private java.lang.Boolean otApproval;
				private java.lang.String otInChargeId;
				private java.util.Date approvedDate;
				private java.lang.String approvedTime;
				private java.lang.String otInChargeSignature;
				private java.lang.String otRoomId;
				private java.lang.String otBedId;
				private java.lang.String approvalStatus;
				private java.lang.String postOperativeSpecimenId;
				private java.lang.String anesthesiologistId;
				private java.lang.String anesthesiologistName;
	
	// collections
	private java.util.List<com.floreantpos.model.Customer> surgeons;
	private java.util.List<com.floreantpos.model.Customer> assistantSurgeons;
	private java.util.List<com.floreantpos.model.User> scrubNurses;
	private java.util.List<com.floreantpos.model.User> circulatingNurses;
	private java.util.List<com.floreantpos.model.User> technicians;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: SURGERY_STATUS
	 */

	public java.lang.String getSurgeryStatus () {
			return surgeryStatus;
	}



	/**
	 * Set the value related to the column: SURGERY_STATUS
	 * @param surgeryStatus the SURGERY_STATUS value
	 */
			public void setSurgeryStatus (java.lang.String surgeryStatus) {
			this.surgeryStatus = surgeryStatus;
	}



	/**
	 * Return the value associated with the column: SURGERY_PROCEDURE_STATUS
	 */

	public java.lang.String getSurgeryProcedureStatus () {
			return surgeryProcedureStatus;
	}



	/**
	 * Set the value related to the column: SURGERY_PROCEDURE_STATUS
	 * @param surgeryProcedureStatus the SURGERY_PROCEDURE_STATUS value
	 */
			public void setSurgeryProcedureStatus (java.lang.String surgeryProcedureStatus) {
			this.surgeryProcedureStatus = surgeryProcedureStatus;
	}



	/**
	 * Return the value associated with the column: PATIENT_ID
	 */

	public java.lang.String getPatientId () {
			return patientId;
	}



	/**
	 * Set the value related to the column: PATIENT_ID
	 * @param patientId the PATIENT_ID value
	 */
			public void setPatientId (java.lang.String patientId) {
			this.patientId = patientId;
	}



	/**
	 * Return the value associated with the column: ADMISSION_ID
	 */

	public java.lang.String getAdmissionId () {
			return admissionId;
	}



	/**
	 * Set the value related to the column: ADMISSION_ID
	 * @param admissionId the ADMISSION_ID value
	 */
			public void setAdmissionId (java.lang.String admissionId) {
			this.admissionId = admissionId;
	}



	/**
	 * Return the value associated with the column: ORDER_ID
	 */

	public java.lang.String getOrderId () {
			return orderId;
	}



	/**
	 * Set the value related to the column: ORDER_ID
	 * @param orderId the ORDER_ID value
	 */
			public void setOrderId (java.lang.String orderId) {
			this.orderId = orderId;
	}



	/**
	 * Return the value associated with the column: URGENCY_LEVEL
	 */

	public java.lang.String getUrgencyLevel () {
			return urgencyLevel;
	}



	/**
	 * Set the value related to the column: URGENCY_LEVEL
	 * @param urgencyLevel the URGENCY_LEVEL value
	 */
			public void setUrgencyLevel (java.lang.String urgencyLevel) {
			this.urgencyLevel = urgencyLevel;
	}



	/**
	 * Return the value associated with the column: SURGERY
	 */

	public java.lang.String getSurgeryItemId () {
			return surgeryItemId;
	}



	/**
	 * Set the value related to the column: SURGERY
	 * @param surgeryItemId the SURGERY value
	 */
			public void setSurgeryItemId (java.lang.String surgeryItemId) {
			this.surgeryItemId = surgeryItemId;
	}



	/**
	 * Return the value associated with the column: SURGERY_DIAGNOSIS_ITEMS
	 */

	public java.lang.String getSurgeryDiagnosisItems () {
			return surgeryDiagnosisItems;
	}



	/**
	 * Set the value related to the column: SURGERY_DIAGNOSIS_ITEMS
	 * @param surgeryDiagnosisItems the SURGERY_DIAGNOSIS_ITEMS value
	 */
			public void setSurgeryDiagnosisItems (java.lang.String surgeryDiagnosisItems) {
			this.surgeryDiagnosisItems = surgeryDiagnosisItems;
	}



	/**
	 * Return the value associated with the column: SURGERY_MEDICINE_ITEMS
	 */

	public java.lang.String getSurgeryMedicineItems () {
			return surgeryMedicineItems;
	}



	/**
	 * Set the value related to the column: SURGERY_MEDICINE_ITEMS
	 * @param surgeryMedicineItems the SURGERY_MEDICINE_ITEMS value
	 */
			public void setSurgeryMedicineItems (java.lang.String surgeryMedicineItems) {
			this.surgeryMedicineItems = surgeryMedicineItems;
	}



	/**
	 * Return the value associated with the column: REQUESTED_DATE
	 */

	public java.util.Date getRequestedDate () {
			return requestedDate;
	}



	/**
	 * Set the value related to the column: REQUESTED_DATE
	 * @param requestedDate the REQUESTED_DATE value
	 */
			public void setRequestedDate (java.util.Date requestedDate) {
			this.requestedDate = requestedDate;
	}



	/**
	 * Return the value associated with the column: REQUESTED_TIME
	 */

	public java.lang.String getRequestedTime () {
			return requestedTime;
	}



	/**
	 * Set the value related to the column: REQUESTED_TIME
	 * @param requestedTime the REQUESTED_TIME value
	 */
			public void setRequestedTime (java.lang.String requestedTime) {
			this.requestedTime = requestedTime;
	}



	/**
	 * Return the value associated with the column: EXPECTED_SURGERY_DURATION
	 */

	public int getExpectedSurgeryDuration () {
			return expectedSurgeryDuration;
	}



	/**
	 * Set the value related to the column: EXPECTED_SURGERY_DURATION
	 * @param expectedSurgeryDuration the EXPECTED_SURGERY_DURATION value
	 */
			public void setExpectedSurgeryDuration (int expectedSurgeryDuration) {
			this.expectedSurgeryDuration = expectedSurgeryDuration;
	}



	/**
	 * Return the value associated with the column: CONSENT_SIGNED
	 */

	public java.lang.Boolean isConsentSigned () {
					return consentSigned == null ? Boolean.FALSE : consentSigned;
		}

	public java.lang.Boolean getConsentSigned () {
				return consentSigned == null ? Boolean.FALSE : consentSigned;
			}


	/**
	 * Set the value related to the column: CONSENT_SIGNED
	 * @param consentSigned the CONSENT_SIGNED value
	 */
			public void setConsentSigned (java.lang.Boolean consentSigned) {
			this.consentSigned = consentSigned;
	}



	/**
	 * Return the value associated with the column: CONSENT_SIGNED_BY
	 */

	public java.lang.String getConsentSignedBy () {
			return consentSignedBy;
	}



	/**
	 * Set the value related to the column: CONSENT_SIGNED_BY
	 * @param consentSignedBy the CONSENT_SIGNED_BY value
	 */
			public void setConsentSignedBy (java.lang.String consentSignedBy) {
			this.consentSignedBy = consentSignedBy;
	}



	/**
	 * Return the value associated with the column: RELATION_WITH_PATIENT
	 */

	public java.lang.String getRelationWithPatient () {
			return relationWithPatient;
	}



	/**
	 * Set the value related to the column: RELATION_WITH_PATIENT
	 * @param relationWithPatient the RELATION_WITH_PATIENT value
	 */
			public void setRelationWithPatient (java.lang.String relationWithPatient) {
			this.relationWithPatient = relationWithPatient;
	}



	/**
	 * Return the value associated with the column: BLOOD_REQUIRED
	 */

	public java.lang.Boolean isBloodRequired () {
					return bloodRequired == null ? Boolean.FALSE : bloodRequired;
		}

	public java.lang.Boolean getBloodRequired () {
				return bloodRequired == null ? Boolean.FALSE : bloodRequired;
			}


	/**
	 * Set the value related to the column: BLOOD_REQUIRED
	 * @param bloodRequired the BLOOD_REQUIRED value
	 */
			public void setBloodRequired (java.lang.Boolean bloodRequired) {
			this.bloodRequired = bloodRequired;
	}



	/**
	 * Return the value associated with the column: BLOOD_GROUP
	 */

	public java.lang.String getBloodGroup () {
			return bloodGroup;
	}



	/**
	 * Set the value related to the column: BLOOD_GROUP
	 * @param bloodGroup the BLOOD_GROUP value
	 */
			public void setBloodGroup (java.lang.String bloodGroup) {
			this.bloodGroup = bloodGroup;
	}



	/**
	 * Return the value associated with the column: BLOOD_TYPE
	 */

	public java.lang.String getBloodType () {
			return bloodType;
	}



	/**
	 * Set the value related to the column: BLOOD_TYPE
	 * @param bloodType the BLOOD_TYPE value
	 */
			public void setBloodType (java.lang.String bloodType) {
			this.bloodType = bloodType;
	}



	/**
	 * Return the value associated with the column: QUANTITY
	 */

	public java.lang.Integer getQuantity () {
						return quantity == null ? Integer.valueOf(0) : quantity;
		}



	/**
	 * Set the value related to the column: QUANTITY
	 * @param quantity the QUANTITY value
	 */
			public void setQuantity (java.lang.Integer quantity) {
			this.quantity = quantity;
	}



	/**
	 * Return the value associated with the column: volume
	 */

	public java.lang.Double getVolume () {
						return volume == null ? Double.valueOf(0) : volume;
		}



	/**
	 * Set the value related to the column: volume
	 * @param volume the volume value
	 */
			public void setVolume (java.lang.Double volume) {
			this.volume = volume;
	}



	/**
	 * Return the value associated with the column: unit
	 */

	public java.lang.String getUnit () {
			return unit;
	}



	/**
	 * Set the value related to the column: unit
	 * @param unit the unit value
	 */
			public void setUnit (java.lang.String unit) {
			this.unit = unit;
	}



	/**
	 * Return the value associated with the column: DOCTOR_APPROVAL
	 */

	public java.lang.Boolean isDoctorApproval () {
					return doctorApproval == null ? Boolean.FALSE : doctorApproval;
		}

	public java.lang.Boolean getDoctorApproval () {
				return doctorApproval == null ? Boolean.FALSE : doctorApproval;
			}


	/**
	 * Set the value related to the column: DOCTOR_APPROVAL
	 * @param doctorApproval the DOCTOR_APPROVAL value
	 */
			public void setDoctorApproval (java.lang.Boolean doctorApproval) {
			this.doctorApproval = doctorApproval;
	}



	/**
	 * Return the value associated with the column: APPROVED_BY
	 */

	public java.lang.String getApprovedById () {
			return approvedById;
	}



	/**
	 * Set the value related to the column: APPROVED_BY
	 * @param approvedById the APPROVED_BY value
	 */
			public void setApprovedById (java.lang.String approvedById) {
			this.approvedById = approvedById;
	}



	/**
	 * Return the value associated with the column: DOCTOR_APPROVAL_DATE
	 */

	public java.util.Date getDoctorApprovalDate () {
			return doctorApprovalDate;
	}



	/**
	 * Set the value related to the column: DOCTOR_APPROVAL_DATE
	 * @param doctorApprovalDate the DOCTOR_APPROVAL_DATE value
	 */
			public void setDoctorApprovalDate (java.util.Date doctorApprovalDate) {
			this.doctorApprovalDate = doctorApprovalDate;
	}



	/**
	 * Return the value associated with the column: DOCTOR_APPROVAL_SIGNATURE
	 */

	public java.lang.String getDoctorApprovalSignature () {
			return doctorApprovalSignature;
	}



	/**
	 * Set the value related to the column: DOCTOR_APPROVAL_SIGNATURE
	 * @param doctorApprovalSignature the DOCTOR_APPROVAL_SIGNATURE value
	 */
			public void setDoctorApprovalSignature (java.lang.String doctorApprovalSignature) {
			this.doctorApprovalSignature = doctorApprovalSignature;
	}



	/**
	 * Return the value associated with the column: OT_APPROVAL
	 */

	public java.lang.Boolean isOtApproval () {
					return otApproval == null ? Boolean.FALSE : otApproval;
		}

	public java.lang.Boolean getOtApproval () {
				return otApproval == null ? Boolean.FALSE : otApproval;
			}


	/**
	 * Set the value related to the column: OT_APPROVAL
	 * @param otApproval the OT_APPROVAL value
	 */
			public void setOtApproval (java.lang.Boolean otApproval) {
			this.otApproval = otApproval;
	}



	/**
	 * Return the value associated with the column: OT_IN_CHARGE
	 */

	public java.lang.String getOtInChargeId () {
			return otInChargeId;
	}



	/**
	 * Set the value related to the column: OT_IN_CHARGE
	 * @param otInChargeId the OT_IN_CHARGE value
	 */
			public void setOtInChargeId (java.lang.String otInChargeId) {
			this.otInChargeId = otInChargeId;
	}



	/**
	 * Return the value associated with the column: APPROVED_DATE
	 */

	public java.util.Date getApprovedDate () {
			return approvedDate;
	}



	/**
	 * Set the value related to the column: APPROVED_DATE
	 * @param approvedDate the APPROVED_DATE value
	 */
			public void setApprovedDate (java.util.Date approvedDate) {
			this.approvedDate = approvedDate;
	}



	/**
	 * Return the value associated with the column: APPROVED_TIME
	 */

	public java.lang.String getApprovedTime () {
			return approvedTime;
	}



	/**
	 * Set the value related to the column: APPROVED_TIME
	 * @param approvedTime the APPROVED_TIME value
	 */
			public void setApprovedTime (java.lang.String approvedTime) {
			this.approvedTime = approvedTime;
	}



	/**
	 * Return the value associated with the column: OT_IN_CHARGE_SIGNATURE
	 */

	public java.lang.String getOtInChargeSignature () {
			return otInChargeSignature;
	}



	/**
	 * Set the value related to the column: OT_IN_CHARGE_SIGNATURE
	 * @param otInChargeSignature the OT_IN_CHARGE_SIGNATURE value
	 */
			public void setOtInChargeSignature (java.lang.String otInChargeSignature) {
			this.otInChargeSignature = otInChargeSignature;
	}



	/**
	 * Return the value associated with the column: OT_ROOM
	 */

	public java.lang.String getOtRoomId () {
			return otRoomId;
	}



	/**
	 * Set the value related to the column: OT_ROOM
	 * @param otRoomId the OT_ROOM value
	 */
			public void setOtRoomId (java.lang.String otRoomId) {
			this.otRoomId = otRoomId;
	}



	/**
	 * Return the value associated with the column: OT_BED_ID
	 */

	public java.lang.String getOtBedId () {
			return otBedId;
	}



	/**
	 * Set the value related to the column: OT_BED_ID
	 * @param otBedId the OT_BED_ID value
	 */
			public void setOtBedId (java.lang.String otBedId) {
			this.otBedId = otBedId;
	}



	/**
	 * Return the value associated with the column: APPROVAL_STATUS
	 */

	public java.lang.String getApprovalStatus () {
			return approvalStatus;
	}



	/**
	 * Set the value related to the column: APPROVAL_STATUS
	 * @param approvalStatus the APPROVAL_STATUS value
	 */
			public void setApprovalStatus (java.lang.String approvalStatus) {
			this.approvalStatus = approvalStatus;
	}



	/**
	 * Return the value associated with the column: POST_OPERATIVE_SPECIMEN_ID
	 */

	public java.lang.String getPostOperativeSpecimenId () {
			return postOperativeSpecimenId;
	}



	/**
	 * Set the value related to the column: POST_OPERATIVE_SPECIMEN_ID
	 * @param postOperativeSpecimenId the POST_OPERATIVE_SPECIMEN_ID value
	 */
			public void setPostOperativeSpecimenId (java.lang.String postOperativeSpecimenId) {
			this.postOperativeSpecimenId = postOperativeSpecimenId;
	}



	/**
	 * Return the value associated with the column: ANESTHESIOLOGIST_id
	 */

	public java.lang.String getAnesthesiologistId () {
			return anesthesiologistId;
	}



	/**
	 * Set the value related to the column: ANESTHESIOLOGIST_id
	 * @param anesthesiologistId the ANESTHESIOLOGIST_id value
	 */
			public void setAnesthesiologistId (java.lang.String anesthesiologistId) {
			this.anesthesiologistId = anesthesiologistId;
	}



	/**
	 * Return the value associated with the column: ANESTHESIOLOGIST_NAME
	 */

	public java.lang.String getAnesthesiologistName () {
			return anesthesiologistName;
	}



	/**
	 * Set the value related to the column: ANESTHESIOLOGIST_NAME
	 * @param anesthesiologistName the ANESTHESIOLOGIST_NAME value
	 */
			public void setAnesthesiologistName (java.lang.String anesthesiologistName) {
			this.anesthesiologistName = anesthesiologistName;
	}



	/**
	 * Return the value associated with the column: surgeons
	 */

	public java.util.List<com.floreantpos.model.Customer> getSurgeons () {
			return surgeons;
	}



	/**
	 * Set the value related to the column: surgeons
	 * @param surgeons the surgeons value
	 */
			public void setSurgeons (java.util.List<com.floreantpos.model.Customer> surgeons) {
			this.surgeons = surgeons;
	}

	public void addTosurgeons (com.floreantpos.model.Customer customer) {
		if (null == getSurgeons()) setSurgeons(new java.util.ArrayList<com.floreantpos.model.Customer>());
		getSurgeons().add(customer);
	}



	/**
	 * Return the value associated with the column: assistantSurgeons
	 */

	public java.util.List<com.floreantpos.model.Customer> getAssistantSurgeons () {
			return assistantSurgeons;
	}



	/**
	 * Set the value related to the column: assistantSurgeons
	 * @param assistantSurgeons the assistantSurgeons value
	 */
			public void setAssistantSurgeons (java.util.List<com.floreantpos.model.Customer> assistantSurgeons) {
			this.assistantSurgeons = assistantSurgeons;
	}

	public void addToassistantSurgeons (com.floreantpos.model.Customer customer) {
		if (null == getAssistantSurgeons()) setAssistantSurgeons(new java.util.ArrayList<com.floreantpos.model.Customer>());
		getAssistantSurgeons().add(customer);
	}



	/**
	 * Return the value associated with the column: scrubNurses
	 */

	public java.util.List<com.floreantpos.model.User> getScrubNurses () {
			return scrubNurses;
	}



	/**
	 * Set the value related to the column: scrubNurses
	 * @param scrubNurses the scrubNurses value
	 */
			public void setScrubNurses (java.util.List<com.floreantpos.model.User> scrubNurses) {
			this.scrubNurses = scrubNurses;
	}

	public void addToscrubNurses (com.floreantpos.model.User user) {
		if (null == getScrubNurses()) setScrubNurses(new java.util.ArrayList<com.floreantpos.model.User>());
		getScrubNurses().add(user);
	}



	/**
	 * Return the value associated with the column: circulatingNurses
	 */

	public java.util.List<com.floreantpos.model.User> getCirculatingNurses () {
			return circulatingNurses;
	}



	/**
	 * Set the value related to the column: circulatingNurses
	 * @param circulatingNurses the circulatingNurses value
	 */
			public void setCirculatingNurses (java.util.List<com.floreantpos.model.User> circulatingNurses) {
			this.circulatingNurses = circulatingNurses;
	}

	public void addTocirculatingNurses (com.floreantpos.model.User user) {
		if (null == getCirculatingNurses()) setCirculatingNurses(new java.util.ArrayList<com.floreantpos.model.User>());
		getCirculatingNurses().add(user);
	}



	/**
	 * Return the value associated with the column: technicians
	 */

	public java.util.List<com.floreantpos.model.User> getTechnicians () {
			return technicians;
	}



	/**
	 * Set the value related to the column: technicians
	 * @param technicians the technicians value
	 */
			public void setTechnicians (java.util.List<com.floreantpos.model.User> technicians) {
			this.technicians = technicians;
	}

	public void addTotechnicians (com.floreantpos.model.User user) {
		if (null == getTechnicians()) setTechnicians(new java.util.ArrayList<com.floreantpos.model.User>());
		getTechnicians().add(user);
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.SurgeryInfo)) return false;
		else {
			com.floreantpos.model.SurgeryInfo surgeryInfo = (com.floreantpos.model.SurgeryInfo) obj;
			if (null == this.getId() || null == surgeryInfo.getId()) return this == obj;
			else return (this.getId().equals(surgeryInfo.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}