package com.floreantpos.report;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.NumberUtil;

public class SalesDetailsReportData implements Serializable {

	public final static String JSON_PROP_AGENT_ID = "agentId"; //$NON-NLS-1$
	public final static String JSON_PROP_ORDER_ID = "orderId"; //$NON-NLS-1$
	public final static String JSON_PROP_ORDER_DATE = "orderDate"; //$NON-NLS-1$
	public final static String JSON_PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public final static String JSON_PROP_GROSS_SALES = "grossSales"; //$NON-NLS-1$
	public final static String JSON_PROP_DISCOUNT = "discount"; //$NON-NLS-1$
	public final static String JSON_PROP_RETURN_ITEM_RF = "returnItemRF"; //$NON-NLS-1$
	public final static String JSON_PROP_REFUND = "refund"; //$NON-NLS-1$
	public final static String JSON_PROP_AGENT_FEE = "agentFee"; //$NON-NLS-1$
	public final static String JSON_PROP_RF_ON_NET_SALES = "rFOnNetSales"; //$NON-NLS-1$
	public final static String JSON_PROP_DUE_AMOUNT = "dueAmount"; //$NON-NLS-1$
	public final static String JSON_PROP_LAB_DOCTOR_FEE = "labDoctorFee"; //$NON-NLS-1$

	private String outletId;
	private String agentName;
	private String agentId;
	private String orderId;
	private Date orderDate;
	private String patientName;
	private String patientId;
	private String orderDateDisplay;
	private double grossSales;
	private double discount;
	private double returnItemRF;
	private double refund;
	private double agentFee;
	private Double rFOnNetSales;
	private double labDoctorFee;
	private double netSales;
	private double dueAmount;
	private String customerId;
	private String customerName;

	public SalesDetailsReportData() {
	}

	public SalesDetailsReportData(Ticket ticket) {
		String referrerId = ticket.getReferrerId();
		if (StringUtils.isNotBlank(referrerId)) {
			Customer referrer = CustomerDAO.getInstance().get(referrerId);
			if (referrer != null) {
				setAgentName(referrer.getName());
				setAgentId(referrerId);
			}
		}
		setOrderId(ticket.getId());
		setOutletId(ticket.getOutletId());
		setOrderDate(ticket.getCreateDate());
		Customer customer = ticket.getCustomer();
		if (customer != null) {
			setPatientName(customer.getName());
			setPatientId(customer.getId());
		}
		setGrossSales(ticket.getSubtotalAmount());
		setDiscount(ticket.getDiscountAmount());
		setRefund(ticket.getRefundAmount());
		setAgentFee(ticket.getTotalReferrerFee());
		setlabDoctorFee(ticket.getLabDoctorFee());

		setNetSales(grossSales - (discount + refund + agentFee + labDoctorFee));

		setDueAmount(ticket.getDueAmount());
	}

	public void calculateNetSales() {
		if (!NumberUtil.isZero(refund)) {
			refund = (-1) * refund;
		}
		setNetSales(grossSales - (discount + refund + agentFee + rFOnNetSales + labDoctorFee));
	}

	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public String getPatientId() {
		return patientId;
	}

	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}

	public double getAgentFee() {
		return agentFee;
	}

	public void setAgentFee(double agentFee) {
		this.agentFee = agentFee;
	}

	public String getOutletId() {
		return outletId;
	}

	public void setOutletId(String outletId) {
		this.outletId = outletId;
	}

	public String getAgentName() {
		return agentName;
	}

	public void setAgentName(String agentName) {
		this.agentName = agentName;
	}

	public String getAgentId() {
		return agentId;
	}

	public void setAgentId(String agentId) {
		this.agentId = agentId;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public Date getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(Date orderDate) {
		this.orderDate = orderDate;
	}

	public double getGrossSales() {
		return grossSales;
	}

	public void setGrossSales(double grossSales) {
		this.grossSales = grossSales;
	}

	public double getDiscount() {
		return discount;
	}

	public void setDiscount(double discount) {
		this.discount = discount;
	}

	public double getRefund() {
		return refund;
	}

	public void setRefund(double refund) {
		this.refund = refund;
	}

	public double getlabDoctorFee() {
		return labDoctorFee;
	}

	public void setlabDoctorFee(double labDrFee) {
		this.labDoctorFee = labDrFee;
	}

	public String getOrderDateDisplay() {
		return DateUtil.formatDateWithTime(DateUtil.convertServerTimeToBrowserTime(getOrderDate()));
	}

	public void setOrderDateDisplay(String orderDateDisplay) {
	}

	public double getNetSales() {
		return netSales;
	}

	public void setNetSales(double netSales) {
		this.netSales = netSales;
	}

	public double getDueAmount() {
		return dueAmount;
	}

	public void setDueAmount(double dueAmount) {
		this.dueAmount = dueAmount;
	}

	public double getReturnItemRF() {
		return returnItemRF;
	}

	public void setReturnItemRF(double returnItemRF) {
		this.returnItemRF = returnItemRF;
	}

	public Double getrFOnNetSales() {
		return rFOnNetSales == null ? Double.valueOf(0) : rFOnNetSales;
	}

	public void setrFOnNetSales(Double rFOnNetSales) {
		this.rFOnNetSales = rFOnNetSales;
	}

	public String getCustomerId() {
		return customerId;
	}

	public void setCustomerId(String customerId) {
		this.customerId = customerId;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
}
