package com.floreantpos.report.model;

import com.floreantpos.report.LabDoctorFeeReportData;
import com.floreantpos.swing.ListTableModel;

public class LabDoctorFeeReportModel extends ListTableModel {
	public LabDoctorFeeReportModel() {
		super(new String[] { "labDoctorName", "orderId", "orderDate", "patientName", "testName", "labDoctorFee", "labDoctorPaid", "labDoctorDue", "labDoctorId",
				"patientId" });
	}

	@Override
	public Object getValueAt(int rowIndex, int columnIndex) {
		LabDoctorFeeReportData reportData = (LabDoctorFeeReportData) rows.get(rowIndex);
		switch (columnIndex) {
			case 0:
				return reportData.getLabDoctorName();

			case 1:
				return reportData.getOrderId();

			case 2:
				return reportData.getOrderDateDisplay();

			case 3:
				return reportData.getPatientName();

			case 4:
				return reportData.getTestName();

			case 5:
				return reportData.getLabDoctorFee();

			case 6:
				return reportData.getLabDoctorFeePaidAmount();

			case 7:
				return reportData.getLabDoctorFeeDueAmount();

			case 8:
				return reportData.getLabDoctorId();

			case 9:
				return reportData.getPatientId();

		}
		return null;
	}

}