/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;

public class UpdateDBTo387 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo387(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() throws Exception {
		PosLog.info(getClass(), "Updating " + schemaName + " schema.");

		List<String> userTypeIds = new ArrayList<String>();
		try (Session session = sessionFactory.openSession()) {
			Transaction transaction = session.beginTransaction();

			List<User> users = UserDAO.getInstance().findAll(session);
			for (User user : users) {
				String userTypeId = user.getUserTypeId();
				if (StringUtils.isBlank(userTypeId)) {
					continue;
				}

				if (userTypeIds.contains(userTypeId)) {
					PosLog.debug(UpdateDBTo387.class, "Role: " + userTypeId + " already updated.");
					continue;
				}

				UserType existingUserType = UserTypeDAO.getInstance().get(userTypeId, session);
				if (existingUserType == null) {
					continue;
				}

				PosLog.debug(UpdateDBTo387.class,
						"Found > User: " + user.getFullName() + ", Role: " + existingUserType.getName() + ", ID: " + existingUserType.getId());

				Set<UserPermission> existingUserPermissions = existingUserType.getPermissions();
				if (existingUserPermissions.contains(UserPermission.VIEW_BACK_OFFICE)) {
					PosLog.debug(UpdateDBTo387.class, "Updating BO role > User: " + user.getFullName() + ", Role: " + existingUserType.getName());

					HashSet<UserPermission> permissions = new HashSet<UserPermission>();
					permissions.addAll(existingUserPermissions);
					permissions.addAll(Arrays.asList(UserPermission.backofficeMenuPermissions));
					//permissions.addAll(Arrays.asList(UserPermission.byzLogicsBackofficeMenuPermissions));
					existingUserType.setPermissions(permissions);
					session.merge(existingUserType);
				}

				userTypeIds.add(userTypeId);
			}
			transaction.commit();
		}
	}
}