package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum MedicationTakingInstruction {
	ANY("Any"), BEFORE_MEAL("Before meal"), AFTER_MEAL("After meal"), IMMEDIATE("Immediate");

	private String displayName;

	MedicationTakingInstruction(String displayName) {
		this.displayName = displayName;
	}

	@Override
	public String toString() {
		return displayName;
	}

	public static MedicationTakingInstruction fromString(String takingTimeName) {
		if (StringUtils.isBlank(takingTimeName)) {
			return null;
		}
		MedicationTakingInstruction[] takingTimes = values();
		for (MedicationTakingInstruction takingTime : takingTimes) {
			if (takingTime.name().equals(takingTimeName)) {
				return takingTime;
			}
			else if (takingTime.name().equalsIgnoreCase(takingTimeName.replaceAll(" ", ""))) { //$NON-NLS-1$ //$NON-NLS-2$
				return takingTime;
			}
		}
		return null;
	}

	public static String getDisplayStringFromName(String takingTimeName) {
		MedicationTakingInstruction fromString = fromString(takingTimeName);
		return fromString == null ? StringUtils.EMPTY : fromString.displayName;
	}
}
