package com.floreantpos.model;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.floreantpos.model.base.BaseRoom;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.util.NumberUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class Room extends BaseRoom implements PropertyContainer, TimedModel {
	private static final long serialVersionUID = 1L;
	private transient JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Room() {
	}

	/**
	 * Constructor for primary key
	 */
	public Room(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return super.getName();
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public void putRentPerBed(double bedRent) {
		addProperty("rentPerBed", NumberUtil.format(bedRent)); //$NON-NLS-1$
	}

	public double getRentPerBed() {
		return getDoubleProperty("rentPerBed"); //$NON-NLS-1$
	}

	public void putAdmissionCharge(double admissionCharge) {
		addProperty("admissionCharge", NumberUtil.format(admissionCharge)); //$NON-NLS-1$
	}

	public double getAdmissionCharge() {
		return getDoubleProperty("admissionCharge"); //$NON-NLS-1$
	}

	public void putNumberOfBeds(int numOfBeds) {
		addProperty("numberOfBeds", String.valueOf(numOfBeds)); //$NON-NLS-1$
	}

	public int getNumberOfBeds() {
		return getIntProperty("numberOfBeds"); //$NON-NLS-1$
	}

	@XmlTransient
	@JsonIgnore
	public List<MenuItem> getEquipments() {
		List<MenuItem> equipments = new ArrayList<>();
		JsonObject jsonProperties = getPropertyStore();
		if (jsonProperties == null || !jsonProperties.has("equipments")) { //$NON-NLS-1$
			return equipments;
		}
		JsonArray equipmentJsonArray = jsonProperties.get("equipments").getAsJsonArray(); //$NON-NLS-1$
		for (int i = 0; i < equipmentJsonArray.size(); i++) {
			String itemId = equipmentJsonArray.get(i).getAsString();
			if (StringUtils.isBlank(itemId)) {
				continue;
			}
			MenuItem item = MenuItemDAO.getInstance().get(itemId);
			if (item == null) {
				continue;
			}
			equipments.add(item);
		}
		return equipments;
	}

	public void setEquipments(List<MenuItem> equipments) {
		if (equipments == null) {
			equipments = new ArrayList<>();
		}
		JsonArray equipmentJsonArray = new JsonArray();
		for (MenuItem item : equipments) {
			equipmentJsonArray.add(item.getId());
		}
		getPropertyStore().add("equipments", equipmentJsonArray); //$NON-NLS-1$
	}
}