package com.floreantpos.model;

public enum TicketIdSequence {
	INSTANCE, Default(0, "Default"), //$NON-NLS-1$
	SequenceNumber(1, "Sequence Number"), //$NON-NLS-1$
	DateWithNumber(2, "Date with Daily Sequence"), //$NON-NLS-1$
	WeekWithNumber(3, "Week with Weekly Sequence"); //$NON-NLS-1$

	private int id;
	private String name;

	private TicketIdSequence() {
	};

	TicketIdSequence(int id, String name) {
		this.id = id;
		this.name = name;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public TicketIdSequence getTicketIdSequenceById(int id) {
		switch (id) {
			case 1:
				return SequenceNumber;
			case 2:
				return DateWithNumber;
			case 3:
				return WeekWithNumber;
			default:
				return Default;
		}
	}

	@Override
	public String toString() {
		return getName();
	}
}