package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the MEDICATION_SCHEDULE table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="MEDICATION_SCHEDULE"
 */

public abstract class BaseMedicationSchedule  implements Serializable {

	public static String REF = "MedicationSchedule"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_ADMISSION_ID = "admissionId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_DOCTOR_VISIT_MEDICINE_ITEM_ID = "doctorVisitMedicineItemId"; //$NON-NLS-1$
	public static String PROP_ITEM_ID = "itemId"; //$NON-NLS-1$
	public static String PROP_DOCTOR_VISIT_ID = "doctorVisitId"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_EVENT_TIME = "eventTime"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_MEDICATION_TIME = "medicationTime"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_PERFORM_BY_USER_ID = "performByUserId"; //$NON-NLS-1$


	// constructors
	public BaseMedicationSchedule () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseMedicationSchedule (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date createDate;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String outletId;
				private java.lang.String doctorVisitMedicineItemId;
				private java.lang.String itemId;
				private java.lang.String doctorVisitId;
				private java.lang.String admissionId;
				private java.lang.String patientId;
				private java.lang.String name;
				private java.lang.String status;
				private java.lang.String performByUserId;
				private java.util.Date eventTime;
				private java.util.Date medicationTime;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_VISIT_MEDICINE_ITEM_ID
	 */

	public java.lang.String getDoctorVisitMedicineItemId () {
			return doctorVisitMedicineItemId;
	}



	/**
	 * Set the value related to the column: DOCTOR_VISIT_MEDICINE_ITEM_ID
	 * @param doctorVisitMedicineItemId the DOCTOR_VISIT_MEDICINE_ITEM_ID value
	 */
			public void setDoctorVisitMedicineItemId (java.lang.String doctorVisitMedicineItemId) {
			this.doctorVisitMedicineItemId = doctorVisitMedicineItemId;
	}



	/**
	 * Return the value associated with the column: ITEM_ID
	 */

	public java.lang.String getItemId () {
			return itemId;
	}



	/**
	 * Set the value related to the column: ITEM_ID
	 * @param itemId the ITEM_ID value
	 */
			public void setItemId (java.lang.String itemId) {
			this.itemId = itemId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_VISIT_ID
	 */

	public java.lang.String getDoctorVisitId () {
			return doctorVisitId;
	}



	/**
	 * Set the value related to the column: DOCTOR_VISIT_ID
	 * @param doctorVisitId the DOCTOR_VISIT_ID value
	 */
			public void setDoctorVisitId (java.lang.String doctorVisitId) {
			this.doctorVisitId = doctorVisitId;
	}



	/**
	 * Return the value associated with the column: ADMISSION_ID
	 */

	public java.lang.String getAdmissionId () {
			return admissionId;
	}



	/**
	 * Set the value related to the column: ADMISSION_ID
	 * @param admissionId the ADMISSION_ID value
	 */
			public void setAdmissionId (java.lang.String admissionId) {
			this.admissionId = admissionId;
	}



	/**
	 * Return the value associated with the column: PATIENT_ID
	 */

	public java.lang.String getPatientId () {
			return patientId;
	}



	/**
	 * Set the value related to the column: PATIENT_ID
	 * @param patientId the PATIENT_ID value
	 */
			public void setPatientId (java.lang.String patientId) {
			this.patientId = patientId;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: PERFORM_BY_USER_ID
	 */

	public java.lang.String getPerformByUserId () {
			return performByUserId;
	}



	/**
	 * Set the value related to the column: PERFORM_BY_USER_ID
	 * @param performByUserId the PERFORM_BY_USER_ID value
	 */
			public void setPerformByUserId (java.lang.String performByUserId) {
			this.performByUserId = performByUserId;
	}



	/**
	 * Return the value associated with the column: EVENT_TIME
	 */

	public java.util.Date getEventTime () {
			return eventTime;
	}



	/**
	 * Set the value related to the column: EVENT_TIME
	 * @param eventTime the EVENT_TIME value
	 */
			public void setEventTime (java.util.Date eventTime) {
			this.eventTime = eventTime;
	}



	/**
	 * Return the value associated with the column: MEDICATION_TIME
	 */

	public java.util.Date getMedicationTime () {
			return medicationTime;
	}



	/**
	 * Set the value related to the column: MEDICATION_TIME
	 * @param medicationTime the MEDICATION_TIME value
	 */
			public void setMedicationTime (java.util.Date medicationTime) {
			this.medicationTime = medicationTime;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}



	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.MedicationSchedule)) return false;
		else {
			com.floreantpos.model.MedicationSchedule medicationSchedule = (com.floreantpos.model.MedicationSchedule) obj;
			if (null == this.getId() || null == medicationSchedule.getId()) return this == obj;
			else return (this.getId().equals(medicationSchedule.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}