package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the PRICE_TABLE_ITEM table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="PRICE_TABLE_ITEM"
 */

public abstract class BasePriceTableItem  implements Comparable, Serializable {

	public static String REF = "PriceTableItem"; //$NON-NLS-1$
	public static String PROP_PRICE_TABLE_ID = "priceTableId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_PRICE = "price"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_MENU_ITEM_ID = "menuItemId"; //$NON-NLS-1$
	public static String PROP_ITEM_BARCODE = "itemBarcode"; //$NON-NLS-1$
	public static String PROP_UNIT = "unit"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BasePriceTableItem () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BasePriceTableItem (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	 long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String menuItemId;
				private java.lang.String itemBarcode;
				private java.lang.String unit;
				private java.lang.Double price;
				private java.lang.String priceTableId;
				private java.lang.Boolean deleted;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: MENU_ITEM_ID
	 */

	public java.lang.String getMenuItemId () {
			return menuItemId;
	}



	/**
	 * Set the value related to the column: MENU_ITEM_ID
	 * @param menuItemId the MENU_ITEM_ID value
	 */
			public void setMenuItemId (java.lang.String menuItemId) {
			this.menuItemId = menuItemId;
	}



	/**
	 * Return the value associated with the column: ITEM_BARCODE
	 */

	public java.lang.String getItemBarcode () {
			return itemBarcode;
	}



	/**
	 * Set the value related to the column: ITEM_BARCODE
	 * @param itemBarcode the ITEM_BARCODE value
	 */
			public void setItemBarcode (java.lang.String itemBarcode) {
			this.itemBarcode = itemBarcode;
	}
			
	/**
	 * Return the value associated with the column: UNIT
	 */
				public java.lang.String getUnit () {
						return unit;
			}

	/**
	 * Set the value related to the column: UNIT
	 * @param unit the UNIT value
	 */
			public void setUnit (java.lang.String unit) {
			this.unit = unit;
	}


	/**
	 * Return the value associated with the column: PRICE
	 */

	public java.lang.Double getPrice () {
						return price == null ? Double.valueOf(0) : price;
		}



	/**
	 * Set the value related to the column: PRICE
	 * @param price the PRICE value
	 */
			public void setPrice (java.lang.Double price) {
			this.price = price;
	}



	/**
	 * Return the value associated with the column: PRICE_TABLE_ID
	 */

	public java.lang.String getPriceTableId () {
			return priceTableId;
	}



	/**
	 * Set the value related to the column: PRICE_TABLE_ID
	 * @param priceTableId the PRICE_TABLE_ID value
	 */
			public void setPriceTableId (java.lang.String priceTableId) {
			this.priceTableId = priceTableId;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.PriceTableItem)) return false;
		else {
			com.floreantpos.model.PriceTableItem priceTableItem = (com.floreantpos.model.PriceTableItem) obj;
			if (null == this.getId() || null == priceTableItem.getId()) return this == obj;
			else return (this.getId().equals(priceTableItem.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}