package com.floreantpos.payment;

import java.util.List;

import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;

public interface PaymentListener {

	default void paymentDone(Ticket ticket, PosTransaction transaction) {
	}

	default void paymentVoided(Ticket ticket, PosTransaction transaction) {
	}

	default void paymentRefunded(Ticket ticket, PosTransaction transaction) {
	}

	default void paymentCanceled(Ticket ticket) {
	}

	default void paymentDataChanged(Ticket ticket) {
	}
	default void groupPaymentDataChanged(List<Ticket> ticket) {
	}

	default void discountUpdated(Ticket ticket) {
	}

	default void gratuityUpdated(Ticket ticket) {
	}
}
