package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.BloodDonationHistory;
import com.floreantpos.model.BloodGroupType;
import com.floreantpos.model.Donor;
import com.floreantpos.swing.PaginatedListModel;

public class BloodDonationHistoryDAO extends BaseBloodDonationHistoryDAO {

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		BloodDonationHistory bean = (BloodDonationHistory) obj;
		if (bean == null) {
			throw new PosException("Blood donation history not found!");
		}
		bean.setDeleted(Boolean.TRUE);
		update(bean, session);
	}

	@Override
	public List<BloodDonationHistory> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(BloodDonationHistory.class);
			addDeletedFilter(criteria);

			criteria.addOrder(Order.asc(BloodDonationHistory.PROP_DONATION_DATE));
			return criteria.list();
		}
	}

	public void loadHistory(Donor donor, BloodGroupType groupType, PaginatedListModel<BloodDonationHistory> dataModel) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(BloodDonationHistory.class);
			addDeletedFilter(criteria);

			if (donor != null) {
				criteria.add(Restrictions.eq(BloodDonationHistory.PROP_DONOR, donor));
			}

			if (groupType != null) {
				criteria.add(Restrictions.eq(BloodDonationHistory.PROP_BLOOD_GROUP, groupType.name()));
			}

			dataModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());

			criteria.addOrder(Order.desc(BloodDonationHistory.PROP_CREATE_DATE));

			dataModel.setData(criteria.list());
		}
	}

}