package com.floreantpos.model.dao;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.Room;
import com.floreantpos.model.RoomFeature;
import com.floreantpos.swing.PaginatedListModel;

public class RoomFeatureDAO extends BaseRoomFeatureDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public RoomFeatureDAO() {
	}

	public void loadData(PaginatedListModel<RoomFeature> tableModel, String name) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			addDeletedFilter(criteria);
			if (StringUtils.isNotBlank(name)) {
				criteria.add(Restrictions.eq(RoomFeature.PROP_NAME, name));
			}
			tableModel.setNumRows(rowCount(criteria));
			criteria.setFirstResult(tableModel.getCurrentRowIndex());
			criteria.setMaxResults(tableModel.getPageSize());
			tableModel.setData(criteria.list());
		}
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		RoomFeature data = (RoomFeature) obj;
		if (data == null) {
			throw new PosException("Data not found.");
		}
		data.setDeleted(Boolean.TRUE);
		saveOrUpdate(data, session);
	}

}