package com.floreantpos.report.model;

import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;

public class CustomerPaymentReportModel extends ListTableModel {
	public CustomerPaymentReportModel() {
		super(new String[] { "customerName", "customerId", "ticketNo", "transNo", "transTime", "tips", "total" }); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$

	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		CustomerAccountTransactionItem data = (CustomerAccountTransactionItem) rows.get(rowIndex);

		switch (columnIndex) {
			case 0:
				return data.getCustomerName();

			case 1:
				return data.getCustomerId();

			case 2:
				return data.getTicketNo();

			case 3:
				return data.getTransactionNo();
			case 4:
				return DateUtil.formatReportDateAsString(data.getDate());

			case 5:
				return data.getTips();

			case 6:
				return data.getTotalAmount();
		}
		return null;
	}

}
