package com.floreantpos.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.commons.beanutils.BeanUtils;

import com.floreantpos.PosLog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.Department;
import com.floreantpos.model.Discount;
import com.floreantpos.model.GratuityPaymentHistory;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Prescription;
import com.floreantpos.model.PrescriptionItem;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.StockCount;
import com.floreantpos.model.StockCountItem;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.PurchaseOrderItemDAO;

public class XMLTransientUtil {

	/**
	 * This method is used to make XMLTransient MenuItem.
	 * 
	 * @param menuItem The MenuItem
	 * 
	 */
	public static List<MenuItem> makeXMLTransientMenuItem(MenuItem menuItem) {
		if (menuItem == null) {
			return null;
		}
		MenuItemDAO.getInstance().initialize(menuItem);
		List<MenuItem> items = new ArrayList<>();
		if (menuItem.getVariants() != null && !menuItem.getVariants().isEmpty()) {
			for (MenuItem variantMenuItem : menuItem.getVariants()) {
				MenuItemDAO.getInstance().initialize(variantMenuItem);
				makeTransientCommonMenuItem(variantMenuItem);
				items.add(variantMenuItem);
			}
		}
		makeTransientCommonMenuItem(menuItem);
		items.add(menuItem);
		return items;
	}

	public static void makeMenuItemXMLTransient(MenuItem menuItem) {
		if (menuItem == null) {
			return;
		}
		if (menuItem.getVariants() != null) {
			for (MenuItem variantMenuItem : menuItem.getVariants()) {
				makeTransientCommonMenuItem(variantMenuItem);
			}
		}
		makeTransientCommonMenuItem(menuItem);
	}

	public static void makeXMLTransientMenuItem(MenuItem menuItem, boolean initializeVariants) {
		if (menuItem == null) {
			return;
		}
		MenuItemDAO.getInstance().initialize(menuItem);
		if (initializeVariants && menuItem.getVariants() != null && !menuItem.getVariants().isEmpty()) {
			for (MenuItem variantMenuItem : menuItem.getVariants()) {
				MenuItemDAO.getInstance().initialize(variantMenuItem);
				makeTransientCommonMenuItem(variantMenuItem);
			}
		}
		makeTransientCommonMenuItem(menuItem);
	}

	public static void makeTransientCommonMenuItem(MenuItem menuItem) {
		//menuItem.setVariants(null);
		List<ComboItem> comboItems = menuItem.getComboItems();
		if (comboItems != null) {
			for (ComboItem comboItem : comboItems) {
				String itemName = comboItem.getName();
				Double price = comboItem.getPrice();
				comboItem.setMenuItem(new MenuItem(comboItem.getItemId()), false);
				comboItem.setName(itemName);
				comboItem.setPrice(price);
			}
		}
		List<ComboGroup> comboGroups = menuItem.getComboGroups();
		if (comboGroups != null) {
			for (ComboGroup comboGroup : comboGroups) {
				List<MenuItem> groupComboItems = comboGroup.getItems();
				comboGroup.setItems(null);
				if (groupComboItems != null && groupComboItems.size() > 0) {
					for (MenuItem item : groupComboItems) {
						comboGroup.addToitems(new MenuItem(item.getId()));
					}
				}
			}
		}
		List<Attribute> attributes = menuItem.getAttributes();
		if (attributes != null) {
			for (Attribute attribute : attributes) {
				if (attribute.getGroup() == null) {
					continue;
				}
				attribute.getGroup().setAttributes(null);
			}
		}
		List<Discount> discounts = menuItem.getDiscounts();
		if (discounts != null) {
			for (Discount discount : discounts) {
				discount.setMenuCategories(null);
				discount.setMenuGroups(null);
				discount.setMenuItems(null);
			}
		}
		List<MenuItemModifierSpec> menuItemModiferSpecs = menuItem.getMenuItemModiferSpecs();
		if (menuItemModiferSpecs != null) {
			for (MenuItemModifierSpec menuItemModifierSpec : menuItemModiferSpecs) {
				makeXMLTransientSpec(menuItemModifierSpec);
			}
		}
	}

	/**
	 * This method is used to make XMLTransient MenuItemModifierSpec.
	 * 
	 * @param modifierSpec The MenuItemModifierSpec
	 * 
	 */
	public static void makeXMLTransientSpec(MenuItemModifierSpec modifierSpec) {
		MenuItemModifierSpecDAO.getInstance().initialize(modifierSpec);
		List<DefaultMenuModifier> defaultModifierList = modifierSpec.getDefaultModifierList();
		if (defaultModifierList != null && defaultModifierList.size() > 0) {
			for (DefaultMenuModifier defaultMenuModifier : defaultModifierList) {
				MenuModifier loadedModifier = defaultMenuModifier.getModifier();
				if (loadedModifier != null) {
					defaultMenuModifier.setModifier(new MenuModifier(loadedModifier.getId()));
				}
				Multiplier loadedMultiplier = defaultMenuModifier.getMultiplier();
				if (loadedMultiplier != null) {
					defaultMenuModifier.setMultiplier(new Multiplier(loadedMultiplier.getId()));
				}
			}
		}

		String modifierGroupId = modifierSpec.getModifierGroupId();
		modifierSpec.setModifierGroup(null);
		modifierSpec.setModifierGroupId(modifierGroupId);

		Set<MenuItemModifierPage> modifierPages = modifierSpec.getModifierPages();
		for (MenuItemModifierPage menuItemModifierPage : modifierPages) {
			makeXMLTransient(menuItemModifierPage);
		}
	}

	/**
	 * This method is used to make XMLTransient MenuItemModifierPage.
	 * 
	 * @param menuItemModifierPage The MenuItemModifierPage
	 * 
	 */
	public static void makeXMLTransient(MenuItemModifierPage menuItemModifierPage) {
		MenuItemModifierPageDAO.getInstance().initializeItems(menuItemModifierPage);

		String modifierSpecId = menuItemModifierPage.getModifierSpecId();
		menuItemModifierPage.setModifierSpec(null);
		menuItemModifierPage.setModifierSpecId(modifierSpecId);
		List<MenuItemModifierPageItem> pageItems = menuItemModifierPage.getPageItems();
		if (pageItems != null && !pageItems.isEmpty()) {
			for (MenuItemModifierPageItem menuItemModifierPageItem : pageItems) {
				makeXMLTransient(menuItemModifierPageItem);
			}
		}
	}

	private static void makeXMLTransient(MenuItemModifierPageItem modifierPageItem) {
		String menuModifierId = modifierPageItem.getMenuModifierId();
		modifierPageItem.setMenuModifier(null);
		modifierPageItem.setMenuModifierId(menuModifierId);
		String parentPageId = modifierPageItem.getParentPageId();
		modifierPageItem.setParentPage(null);
		modifierPageItem.setParentPageId(parentPageId);
	}

	/**
	 * This method is used to make XMLTransient ModifierGroup.
	 * 
	 * @param modifierGroup The ModifierGroup
	 * 
	 */
	public static void makeXMLTransient(ModifierGroup modifierGroup) {
		ModifierGroupDAO.getInstance().initialize(modifierGroup);
		List<MenuModifier> menuModifierList = modifierGroup.getModifiers();
		if (menuModifierList == null) {
			return;
		}
		for (MenuModifier menuModifier : menuModifierList) {
			menuModifier.setModifierGroups(null);
			menuModifier.setMultiplierPriceList(null);
		}
	}

	/**
	 * This method is used to make XMLTransient MenuGroup.
	 * 
	 * @param menuGroup The MenuGroup
	 * 
	 */
	public static void makeXMLTransient(MenuGroup menuGroup) {
		menuGroup.setMenuPages(null);
		MenuCategory menuCategory = menuGroup.getParent();
		menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
		if (menuCategory != null) {
			makeXMLTransient(menuCategory);
		}
	}

	/**
	 * This method is used to make XMLTransient MenuCategory.
	 * 
	 * @param menuCategory The MenuCategory
	 * 
	 */
	public static void makeXMLTransientCollection(MenuCategory menuCategory) {
		if (isNotEmpty(menuCategory.getDepartments())) {
			List<String> beanIds = new ArrayList<>();
			for (Department bean : menuCategory.getDepartments()) {
				beanIds.add(bean.getId());
			}
			menuCategory.setDepartmentIds(beanIds);
		}
		if (isNotEmpty(menuCategory.getMenuShifts())) {
			List<String> beanIds = new ArrayList<>();
			for (MenuShift bean : menuCategory.getMenuShifts()) {
				beanIds.add(bean.getId());
			}
			menuCategory.setMenuShiftIds(beanIds);
		}
		if (isNotEmpty(menuCategory.getOrderTypes())) {
			List<String> beanIds = new ArrayList<>();
			for (OrderType bean : menuCategory.getOrderTypes()) {
				beanIds.add(bean.getId());
			}
			menuCategory.setOrderTypeIds(beanIds);
		}
		makeXMLTransient(menuCategory);
	}

	public static void makeXMLTransient(MenuCategory menuCategory) {
		menuCategory.setDepartments(null);
		menuCategory.setMenuShifts(null);
		menuCategory.setOrderTypes(null);
		menuCategory.setMenuGroups(null);
		menuCategory.setTerminalTypes(null);
	}

	private static boolean isNotEmpty(Collection<?> dataList) {
		return dataList != null && dataList.size() > 0;
	}

	/**
	 * This method is used to make XMLTransient User.
	 * 
	 * @param user 
	 * 
	 */
	public static void makeXMLTransient(User user) {
		if (user == null)
			return;
		user.setLinkedUser(null);
		if (!user.isRoot()) {
			String parentUserId = user.getParentUserId();
			if (parentUserId != null) {
				user.setParentUser(null);
				user.setParentUserId(parentUserId);
			}
		}
	}

	/**
	 * This method is used to make XMLTransient BookingInfo.
	 * 
	 * @param bookinginfo 
	 * 
	 */
	public static void makeXMLTransient(BookingInfo bookinginfo) {
		bookinginfo.getCustomer();
	}

	/**
	 * This method is used to make XMLTransient MenuPage.
	 * 
	 * @param menuPage 
	 * 
	 */
	public static void makeXMLTransient(MenuPage menuPage) {
		MenuPageDAO.getInstance().initialize(menuPage);
	}

	public static void makeXMLTransient(GratuityPaymentHistory gratuityPaymentHistory) {
		makeXMLTransient(gratuityPaymentHistory.getCashDrawer());
		makeXMLTransient(gratuityPaymentHistory.getPaidBy());
	}

	public static void makeXMLTransient(CashDrawer cashDrawer) {
		//cashDrawer.setCashBreakdownList(null);
	}

	public static void makeXMLTransient(Customer customer) {
		if (customer == null)
			return;
		customer.setDeliveryAddresses(null);
		customer.setCustomerGroup(null);
	}

	public static void makeXMLTransient(AttributeGroup group) {
		if (group == null) {
			return;
		}
		group.setAttributes(null);
	}

	//TODO: Ticket
	/**
	 * This method is used to make XMLTransient Ticket.
	 * 
	 * @param ticket The Ticket
	 * 
	 */
	public static void makeXMLTransient(Ticket ticket) {
		//		ticket.setProperties(null);
		ticket.setDepartment(null);

		List<TicketDiscount> discountList = ticket.getDiscounts();
		if (discountList != null && discountList.size() > 0) {
			for (TicketDiscount ticketDiscount : discountList) {
				makeXMLTransient(ticketDiscount);
			}
		}

		OrderType orderType = ticket.getOrderType();
		if (orderType != null) {
			makeXMLTransient(orderType);
		}

		List<TicketItem> ticketItemList = ticket.getTicketItems();
		if (ticketItemList != null) {
			for (TicketItem ticketItem : ticketItemList) {
				if (ticketItem == null) {
					PosLog.error(XMLTransientUtil.class,
							"Found null ticket item for ticket " + ticket.getId() + ", store: " + ticket.getStoreId() + ", outlet: " + ticket.getOutletId());
					continue;
				}
				makeXMLTransient(ticketItem);
			}
		}
		ArrayList<PosTransaction> transactions = new ArrayList<>(ticket.getTransactions());
		for (PosTransaction posTransaction : transactions) {
			String ticketId = posTransaction.getTicketId();
			posTransaction.setTicket(null);
			posTransaction.setTicketId(ticketId);
		}
	}

	private static void makeXMLTransient(TicketDiscount ticketDiscount) {
		ticketDiscount.setTicket(null);
	}

	private static void makeXMLTransient(TicketItem ticketItem) {
		ticketItem.setTicket(null);
		List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
		if (ticketItemModifiers != null) {
			for (TicketItemModifier ticketItemModifier : ticketItemModifiers) {
				makeXMLTransient(ticketItemModifier);
			}
		}

		TicketItemModifier sizeModifier = ticketItem.getSizeModifier();
		if (sizeModifier != null) {
			makeXMLTransient(sizeModifier);
		}

		Boolean isComboItem = ticketItem.isComboItem();
		if (isComboItem) {
			List<TicketItem> comboTicketItems = ticketItem.getComboItems();
			if (comboTicketItems != null) {
				for (TicketItem cTicketItem : comboTicketItems) {
					makeXMLTransient(cTicketItem);
				}
			}
		}

		String menuItemId = ticketItem.getMenuItemId();
		ticketItem.setMenuItem(null);
		ticketItem.setMenuItemId(menuItemId);

		List<TicketItemDiscount> discountList = ticketItem.getDiscounts();
		if (discountList != null && discountList.size() > 0) {
			for (TicketItemDiscount ticketDiscount : discountList) {
				makeXMLTransient(ticketDiscount);
			}
		}
	}

	/**
	 * This method is used to make XMLTransient OrderType.
	 * 
	 * @param orderType The OrderType
	 * 
	 */
	public static void makeXMLTransient(OrderType orderType) {
		if (orderType == null)
			return;
		orderType.setTerminalTypes(null);
		orderType.setCategories(null);
		orderType.setDepartments(null);

		byte[] imageBytes = orderType.getImageBytes();
		orderType.setImageData(null);
		orderType.setImageBytes(imageBytes);
	}

	//	public static void makeXMLTransient(OrderType orderType) {
	//		if (orderType == null)
	//			return;
	//		orderType.setTerminalTypes(null);
	//		orderType.setCategories(null);
	//		orderType.setDepartments(null);
	//	}

	private static void makeXMLTransient(TicketItemModifier ticketItemModifier) {
		ticketItemModifier.setTicketItem(null);
	}

	private static void makeXMLTransient(TicketItemDiscount ticketDiscount) {
		ticketDiscount.setTicketItem(null);
	}

	public static void makeXMLTransient(InventoryLocation inventoryLocation) {
		InventoryLocation parentLocation = inventoryLocation.getParentLocation();
		if (parentLocation != null) {
			inventoryLocation.setParentLocation(new InventoryLocation(parentLocation.getId(), parentLocation.getOutletId()));
		}
		inventoryLocation.setChildren(null);
	}

	public static void makeXMLTransient(InventoryTransaction inventoryTransaction) {
		MenuItem menuItem = inventoryTransaction.getMenuItem();
		if (menuItem != null) {
			inventoryTransaction.setMenuItem(new MenuItem(menuItem.getId()));
		}
	}

	public static void makeXMLTransient(InventoryVendorItems inventoryVendorItems) {
		MenuItem menuItem = inventoryVendorItems.getItem();
		if (menuItem != null) {
			inventoryVendorItems.setItem(new MenuItem(menuItem.getId()));
		}
	}

	public static void makeXMLTransient(Department department) {
		if (department == null)
			return;
		department.setOrderTypes(null);
		department.setOutlets(null);
	}

	//	private void makeXMLTransient(MenuItem menuItem) {
	//		MenuItemDAO.getInstance().initialize(menuItem);
	//
	//		String parentMenuItemId = menuItem.getParentMenuItemId();
	//		//object.setTerminals(null);
	//		menuItem.setStockUnits(null);
	//		menuItem.setComboGroups(null);
	//		menuItem.setComboItems(null);
	//		menuItem.setParentMenuItem(null);
	//		menuItem.setParentMenuItemId(parentMenuItemId);
	//		menuItem.setPizzaPriceList(null);
	//		menuItem.setAttributes(null);
	//		menuItem.setMenuItemModiferSpecs(null);
	//		menuItem.setPrinterGroup(null);
	//		menuItem.setVariants(null);
	//
	//		MenuGroup menuGroup = menuItem.getParent();
	//		if (menuGroup != null) {
	//
	//			MenuCategory itemCategory = menuGroup.getParent();
	//			MenuCategory category = new MenuCategory();
	//			if (itemCategory != null) {
	//				try {
	//					PropertyUtils.copyProperties(category, itemCategory);
	//					category.setDepartments(null);
	//					category.setOrderTypes(null);
	//
	//				} catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
	//					e.printStackTrace();
	//				}
	//			}
	//			menuGroup.setParent(category);
	//		}
	//	}

	public static void makeXMLTransient(StoreSessionControl item) {
		if (item == null) {
			return;
		}

		StoreSession currentData = item.getCurrentData();
		if (currentData != null) {
			makeXMLTransient(currentData.getOpenedBy());
			makeXMLTransient(currentData.getClosedBy());
		}
	}

	/**
	 * This method is used to make XMLTransient CustomerGroup.
	 * 
	 * @param customerGroup The CustomerGroup
	 * 
	 */
	public static void makeXMLTransient(CustomerGroup customerGroup) {
		CustomerGroupDAO.getInstance().initialize(customerGroup);
		List<Customer> customers = customerGroup.getCustomers();
		if (customers == null) {
			return;
		}
		for (Customer customer : customers) {
			makeXMLTransient(customer);
		}
	}

	/**
	 * This method is used to make XMLTransient MenuModifier.
	 * 
	 * @param menuModifier The MenuModifier
	 * 
	 */
	public static void makeXMLTransient(MenuModifier menuModifier) {
		MenuModifierDAO.getInstance().initialize(menuModifier);

		List<ModifierGroup> modifierGroups = menuModifier.getModifierGroups();
		if (modifierGroups == null) {
			return;
		}
		for (ModifierGroup modifierGroup : modifierGroups) {
			modifierGroup.setModifiers(null);
		}
	}

	public static void makeXMLTransient(TerminalType terminalType) {
		terminalType.setCategories(null);
		terminalType.setOrderTypes(null);
	}

	public static void makeLazy(Department department) {
		List<Outlet> outlets = department.getOutlets();
		department.setOutlets(null);
		if (outlets != null) {
			for (Outlet outlet : outlets) {
				department.addTooutlets(new Outlet(outlet.getId()));
			}
		}
		List<OrderType> orderTypes = department.getOrderTypes();
		department.setOrderTypes(null);
		if (orderTypes != null) {
			for (OrderType orderType : orderTypes) {
				department.addToorderTypes(new OrderType(orderType.getId(), orderType.getOutletId()));
			}
		}
	}

	public static void makeLazy(OrderType orderType) {
		Set<TerminalType> terminalTypes = orderType.getTerminalTypes();
		orderType.setTerminalTypes(null);
		if (terminalTypes != null) {
			for (TerminalType terminalType : terminalTypes) {
				orderType.addToterminalTypes(new TerminalType(terminalType.getId(), terminalType.getOutletId()));
			}
		}
		Set<MenuCategory> categories = orderType.getCategories();
		orderType.setCategories(null);
		if (categories != null) {
			for (MenuCategory category : categories) {
				orderType.addTocategories(new MenuCategory(category.getId()));
			}
		}
		Set<Department> departments = orderType.getDepartments();
		orderType.setDepartments(null);
		if (departments != null) {
			for (Department department : departments) {
				orderType.addTodepartments(new Department(department.getId()));
			}
		}
	}

	public static void makeLazy(TerminalType terminalType) {
		List<MenuCategory> categories = terminalType.getCategories();
		terminalType.setCategories(null);
		if (categories != null) {
			for (MenuCategory category : categories) {
				terminalType.addTocategories(new MenuCategory(category.getId()));
			}
		}
		List<OrderType> orderTypes = terminalType.getOrderTypes();
		terminalType.setOrderTypes(null);
		if (orderTypes != null) {
			for (OrderType orderType : orderTypes) {
				terminalType.addToorderTypes(new OrderType(orderType.getId(), orderType.getOutletId()));
			}
		}
	}

	public static void makeLazy(Discount discount) {
		List<MenuCategory> categories = discount.getMenuCategories();
		discount.setMenuCategories(null);
		if (categories != null) {
			for (MenuCategory category : categories) {
				discount.addTomenuCategories(new MenuCategory(category.getId()));
			}
		}
		List<MenuGroup> groups = discount.getMenuGroups();
		discount.setMenuGroups(null);
		if (groups != null) {
			for (MenuGroup menuGroup : groups) {
				discount.addTomenuGroups(new MenuGroup(menuGroup.getId()));
			}
		}
		List<MenuItem> menuItems = discount.getMenuItems();
		discount.setMenuItems(null);
		if (menuItems != null) {
			for (MenuItem menuItem : menuItems) {
				discount.addTomenuItems(new MenuItem(menuItem.getId()));
			}
		}
	}

	public static void makeLazy(Recepie recipe) {
		List<RecepieItem> items = recipe.getRecepieItems();
		if (items != null && items.size() > 0) {
			for (RecepieItem recepieItem : items) {
				MenuItem inventoryItem = recepieItem.getInventoryItem();
				if (inventoryItem != null) {
					recepieItem.setInventoryItem(new MenuItem(inventoryItem.getId()));
				}
				recepieItem.setRecepie(null);
			}
		}
		if (recipe.getMenuItem() != null) {
			recipe.setMenuItem(new MenuItem(recipe.getMenuItem().getId()));
		}
	}

	public static void makeLazy(PurchaseOrder purchaseOrder) {
		List<PurchaseOrderItem> orderItems = purchaseOrder.getOrderItems();
		if (orderItems != null) {
			for (Iterator<PurchaseOrderItem> iterator = orderItems.iterator(); iterator.hasNext();) {
				PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem) iterator.next();
				PurchaseOrderItemDAO.getInstance().initializeCustomers(purchaseOrderItem);
				purchaseOrderItem.setPurchaseOrder(null);
				Set<Customer> customers = purchaseOrderItem.getCustomers();
				purchaseOrderItem.setCustomers(null);
				if (customers != null && customers.size() > 0) {
					for (Customer customer : customers) {
						purchaseOrderItem.addTocustomers(new Customer(customer.getId()));
					}
				}
				if (purchaseOrderItem.getVendor() != null) {
					purchaseOrderItem.setVendor(new InventoryVendor(purchaseOrder.getVendor().getId()));
				}
			}
		}
		InventoryLocation inventoryLocation = purchaseOrder.getInventoryLocation();
		if (inventoryLocation != null) {
			purchaseOrder.setInventoryLocation(new InventoryLocation(inventoryLocation.getId(), inventoryLocation.getOutletId()));
		}
		if (purchaseOrder.getVendor() != null) {
			purchaseOrder.setVendor(new InventoryVendor(purchaseOrder.getVendor().getId()));
		}
		if (purchaseOrder.getTerminal() != null) {
			purchaseOrder.setTerminal(new Terminal(purchaseOrder.getTerminal().getId(), purchaseOrder.getTerminal().getOutletId()));
		}
	}

	public static void makeLazy(StockCount stockCount) {
		List<StockCountItem> items = stockCount.getCountItems();
		if (items != null) {
			for (Iterator<StockCountItem> iterator = items.iterator(); iterator.hasNext();) {
				StockCountItem stockCountItem = (StockCountItem) iterator.next();
				stockCountItem.setMenuItem(null);
				stockCountItem.setStockCount(null);
				InventoryLocation inventoryLocation = stockCountItem.getInventoryLocation();
				if (inventoryLocation != null) {
					stockCountItem.setInventoryLocation(new InventoryLocation(inventoryLocation.getId(), inventoryLocation.getOutletId()));
				}
			}
		}
		User verifiedBy = stockCount.getVerifiedBy();
		if (verifiedBy != null) {
			stockCount.setVerifiedBy(new User(verifiedBy.getId(), verifiedBy.getOutletId()));
		}
		User user = stockCount.getUser();
		if (user != null) {
			stockCount.setUser(new User(user.getId(), user.getOutletId()));
		}
	}

	public static TerminalType getLazyData(TerminalType terminalType) {
		List<MenuCategory> categories = terminalType.getCategories();
		List<OrderType> orderTypes = terminalType.getOrderTypes();
		if (hasItems(categories) || hasItems(orderTypes)) {
			TerminalType lazyOrderType = new TerminalType();
			copy(lazyOrderType, terminalType);
			return lazyOrderType;
		}
		return null;
	}

	public static OrderType getLazyData(OrderType orderType) {
		Set<TerminalType> terminalTypes = orderType.getTerminalTypes();
		Set<MenuCategory> categories = orderType.getCategories();
		Set<Department> departments = orderType.getDepartments();
		if (hasItems(terminalTypes) || hasItems(categories) || hasItems(departments)) {
			OrderType lazyOrderType = new OrderType();
			copy(lazyOrderType, orderType);
			return lazyOrderType;
		}
		return null;
	}

	public static Department getLazyData(Department department) {
		List<Outlet> outlets = department.getOutlets();
		List<OrderType> orderTypes = department.getOrderTypes();
		if ((outlets != null && outlets.size() > 0) || (orderTypes != null && orderTypes.size() > 0)) {
			Department lazyDepartment = new Department();
			copy(lazyDepartment, department);
			return lazyDepartment;
		}
		return null;
	}

	private static void copy(Object dest, Object source) {
		try {
			BeanUtils.copyProperties(dest, source);
		} catch (Exception e) {
			PosLog.error(XMLTransientUtil.class, e.getMessage());
		}
	}

	private static boolean hasItems(Collection<?> dataList) {
		return dataList != null && dataList.size() > 0;
	}

	public static void makePrescriptionXMLTransient(Prescription prescription) {
		List<PrescriptionItem> items = prescription.getItems();
		if (items != null) {
			for (PrescriptionItem prescriptionItem : items) {
				prescriptionItem.setPrescription(null);
				prescriptionItem.setMenuItem(null);
			}
		}
	}

}
