package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum LedgerEntryType {

	//@formatter:off
	SALES("Sales"),
	PURCHASE("Purchase"),
	ORDER_ENTRY("Order"), 
	SALARY("Salary"),
	EXPENSE("Expense"),
	TRANSFER("Transfer"),
	IN("In"),
	OUT("Out"),
	RF_PAY("Referrer"),
	LDF_PAY("Lab doctor")
	;
	//@formatter:on

	private final String displayName;

	private LedgerEntryType(String displayName) {
		this.displayName = displayName;
	}

	public String getDisplayName() {
		return displayName;
	}

	public static LedgerEntryType fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}

		LedgerEntryType[] values = values();
		for (LedgerEntryType type : values) {
			if (name.equals(type.name())) {
				return type;
			}
		}

		return null;
	}

	@Override
	public String toString() {
		return displayName;
	}

}
