package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

public enum NoteType {

	//@formatter:off
	TERMS_AND_CONDITIONS("Terms and Conditions"), 
	;
	//@formatter:on

	private final String displayString;

	public String getDisplayString() {
		return displayString;
	}

	private NoteType(String agentTypeName) {
		this.displayString = agentTypeName;
	}

	public static NoteType fromString(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}

		NoteType[] values = values();
		for (NoteType agentTypeEnum : values) {
			if (name.equals(agentTypeEnum.name())) {
				return agentTypeEnum;
			}
		}

		return null;
	}

	public static NoteType fromDisplayString(String displayString) {
		if (StringUtils.isEmpty(displayString)) {
			return null;
		}

		NoteType[] values = values();
		for (NoteType agentTypeEnum : values) {
			if (displayString.equals(agentTypeEnum.displayString)) {
				return agentTypeEnum;
			}
		}

		return null;
	}

	@Override
	public String toString() {
		return displayString;
	}

}
