package com.floreantpos.model;

import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BasePrescription;
import com.floreantpos.util.GsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown = true, value = {})
@XmlAccessorType(XmlAccessType.FIELD)
@XmlSeeAlso({ PrescriptionItem.class })
public class Prescription extends BasePrescription implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;
	private transient Customer patient;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Prescription() {
	}

	/**
	 * Constructor for primary key
	 */
	public Prescription(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public String getPatientNameByProperty() {
		return getProperty(Ticket.CUSTOMER_NAME) + " " + getProperty(Ticket.CUSTOMER_LAST_NAME);
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	public String getPatientPhoneNo() {
		return getProperty(Ticket.CUSTOMER_PHONE);
	}

	public String getPatientApproxAge() {
		return getProperty(Ticket.CUSTOMER_AGE);
	}

	public String getPatientAddress() {
		return getProperty(Ticket.CUSTOMER_ADDRESS);
	}

	@XmlTransient
	@JsonIgnore
	public Customer getPatient() {
		return patient;
	}

	public void setPatient(Customer patient) {
		this.patient = patient;
		setPatientId(patient == null ? null : patient.getId());
		if (patient != null) {
			addProperty(Ticket.CUSTOMER_ID, String.valueOf(patient.getId()));
			addProperty(Ticket.CUSTOMER_NAME, patient.getFirstName());
			addProperty(Ticket.CUSTOMER_LAST_NAME, patient.getLastName());
			addProperty(Ticket.CUSTOMER_PHONE, patient.getMobileNo());
			addProperty(Ticket.CUSTOMER_ZIP_CODE, patient.getZipCode());
			addProperty(Ticket.CUSTOMER_TAX_EXEMPT, patient.isTaxExempt().toString());
			addProperty(Ticket.CUSTOMER_EMAIL, patient.getEmail());
			addProperty(Ticket.CUSTOMER_AGE, patient.getApproxAge());
			addProperty(Ticket.CUSTOMER_ADDRESS, patient.getAddress());
		}
	}

	@XmlTransient
	@JsonIgnore
	public List<String> getProblems() {
		return GsonUtil.convertJSONToList(getProperty("problems", "[]"), String.class);
	}

	public void putProblems(List<String> problems) {
		addProperty("problems", GsonUtil.createGson().toJson(problems));
	}

	public String getComments() {
		return getProperty("comments");
	}

	public void putComments(String comments) {
		addProperty("comments", comments);
	}

	public String getHeightInCM() {
		return getProperty("height.cm");
	}

	public void putHeightInCM(String cm) {
		addProperty("height.cm", cm);
	}

	public String getWeightInKG() {
		return getProperty("weight");
	}

	public void putWeightInKG(String weight) {
		addProperty("weight", weight);
	}

	public String getTemparature() {
		return getProperty("temparature");
	}

	public void putTemparature(String temparature) {
		addProperty("temparature", temparature);
	}

	public String getBpm() {
		return getProperty("heartBitPerSecond");
	}

	public void putBpm(String bpm) {
		addProperty("heartBitPerSecond", bpm);
	}

	public String getGender() {
		return getProperty("sex");
	}

	public void putGender(String gender) {
		addProperty("sex", gender);
	}

	public String getBpUp() {
		return getProperty("pressure.up");
	}

	public void putBpUp(String upValue) {
		addProperty("pressure.up", upValue);
	}

	public String getBpDown() {
		return getProperty("pressure.down");
	}

	public void putBpDown(String downValue) {
		addProperty("pressure.down", downValue);
	}

	public String getAgeY() {
		return getProperty("age.y");
	}

	public void putAgeY(String value) {
		addProperty("age.y", value);
	}

	public String getAgeM() {
		return getProperty("age.m");
	}

	public void putAgeM(String value) {
		addProperty("age.m", value);
	}

	public String getAgeD() {
		return getProperty("age.d");
	}

	public void putAgeD(String value) {
		addProperty("age.d", value);
	}

	public String getNotes() {
		return getProperty("notes");
	}

	public void putNotes(String value) {
		addProperty("notes", value);
	}

	@XmlTransient
	public String getDoctorName() {
		return getProperty("doctorName"); //$NON-NLS-1$
	}

	public void putDoctorName(String doctorName) {
		if (doctorName == null) {
			removeProperty("doctorName"); //$NON-NLS-1$
			return;
		}
		addProperty("doctorName", doctorName); //$NON-NLS-1$
	}

	public List<PatientAllergy> getPatientAllergyList() {
		String allergiesList = getProperty("patient_allergy", "[]"); //$NON-NLS-1$ //$NON-NLS-2$
		return GsonUtil.convertJSONToList(allergiesList, PatientAllergy.class);
	}

	public void putPatientAllergyList(List<PatientAllergy> patientAllergies) {
		String json = GsonUtil.createGson().toJson(patientAllergies);
		addProperty("patient_allergy", json); //$NON-NLS-1$
	}

}