package com.floreantpos.model;

public enum TicketType {
	LAB(0), PHARMA(3), IPD(4), OT(5), OUTDOOR(6);

	private int typeNo;

	private TicketType(int typeNo) {
		this.typeNo = typeNo;
	}

	public static TicketType getByTypeNo(Integer no) {
		if (no == null) {
			return TicketType.LAB;
		}
		TicketType[] values = values();
		for (TicketType ticketType : values) {
			if (ticketType.typeNo == no.intValue()) {
				return ticketType;
			}
		}
		return LAB;
	}

	public int getTypeNo() {
		return typeNo;
	}
}
