package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosException;
import com.floreantpos.model.GlobalPrescription;

public class GlobalPrescriptionDAO extends BaseGlobalPrescriptionDAO {

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		GlobalPrescription bean = (GlobalPrescription) obj;
		if (bean == null) {
			throw new PosException("Global Prescription not found!");
		}
		bean.setDeleted(Boolean.TRUE);
		update(bean, session);
	}

	@Override
	public List<GlobalPrescription> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(GlobalPrescription.class);
			addDeletedFilter(criteria);

			criteria.addOrder(Order.asc(GlobalPrescription.PROP_CREATE_DATE));
			return criteria.list();
		}
	}

	public GlobalPrescription getGlobalPrescription(String prescriptionId, String storeId, String outletId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(GlobalPrescription.class);
			addDeletedFilter(criteria);

			criteria.add(Restrictions.eq(GlobalPrescription.PROP_PRESCRIPTION_ID, prescriptionId));
			criteria.add(Restrictions.eq(GlobalPrescription.PROP_STORE_ID, storeId));
			criteria.add(Restrictions.eq(GlobalPrescription.PROP_OUTLET_ID, outletId));

			criteria.addOrder(Order.asc(GlobalPrescription.PROP_CREATE_DATE));
			criteria.setMaxResults(1);
			return (GlobalPrescription) criteria.uniqueResult();
		}

	}

	public List<GlobalPrescription> findPrescriptionsByPatientPhone(String patientMobile) {
		if (StringUtils.isBlank(patientMobile)) {
			throw new PosException("Patient phone number is required");
		}

		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(GlobalPrescription.class);
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(GlobalPrescription.PROP_PATIENT_PHONE, patientMobile));

			criteria.addOrder(Order.asc(GlobalPrescription.PROP_CREATE_DATE));
			return criteria.list();
		}
	}

	public boolean isPresent(String patientPhone) {
		if (StringUtils.isBlank(patientPhone)) {
			throw new PosException("Patient phone number is required");
		}
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(GlobalPrescription.class);
			addDeletedFilter(criteria);

			criteria.add(Restrictions.eq(GlobalPrescription.PROP_PATIENT_PHONE, patientPhone));
			criteria.setMaxResults(1);
			return criteria.uniqueResult() != null;
		}
	}

}