package com.floreantpos.model.dao;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

import com.floreantpos.model.OutdoorTicket;
import com.floreantpos.swing.PaginatedListModel;

public class OutdoorTicketDAO extends BaseOutdoorTicketDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public OutdoorTicketDAO() {
	}

	public void loadOutdoorTickets(PaginatedListModel<OutdoorTicket> dataModel, String patientId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(OutdoorTicket.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(patientId)) {
				criteria.add(Restrictions.eq(OutdoorTicket.PROP_CUSTOMER_ID, patientId));
			}

			dataModel.setNumRows(rowCount(criteria));

			criteria.addOrder(Order.desc(OutdoorTicket.PROP_CREATE_DATE));
			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());
			criteria.setResultTransformer(Transformers.aliasToBean(OutdoorTicket.class));
			dataModel.setData(criteria.list());

		}

	}

}