package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

import com.floreantpos.PosException;
import com.floreantpos.model.SurgeryInfo;
import com.floreantpos.model.Ticket;
import com.floreantpos.swing.PaginatedListModel;

public class SurgeryInfoDAO extends BaseSurgeryInfoDAO {

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	@Override
	protected void delete(Object obj, Session session) {
		SurgeryInfo bean = (SurgeryInfo) obj;
		if (bean == null) {
			throw new PosException("Surgery Info not found!");
		}
		bean.setDeleted(Boolean.TRUE);
		update(bean, session);
	}

	@Override
	public List<SurgeryInfo> findAll() {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(SurgeryInfo.class);
			addDeletedFilter(criteria);

			criteria.addOrder(Order.asc(SurgeryInfo.PROP_REQUESTED_DATE));
			return criteria.list();
		}
	}

	public void loadSurgeryInfo(PaginatedListModel<SurgeryInfo> dataModel) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(SurgeryInfo.class);
			addDeletedFilter(criteria);

			dataModel.setNumRows(rowCount(criteria));

			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());
			criteria.addOrder(Order.asc(SurgeryInfo.PROP_REQUESTED_DATE));
			dataModel.setData(criteria.list());
		}
	}

	public void saveSurgeryInfoWithTicket(Ticket ticketToOrder, SurgeryInfo surgeryInfo) {
		try (Session session = createNewSession()) {
			Transaction tx = session.beginTransaction();

			TicketDAO.getInstance().saveOrUpdate(ticketToOrder, session);

			surgeryInfo.setOrderId(ticketToOrder.getId());

			if (StringUtils.isBlank(surgeryInfo.getId())) {
				save(surgeryInfo, session);
			}
			else {
				saveOrUpdate(surgeryInfo, session);
			}
			tx.commit();
		}
	}

}