/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.db.update;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import org.hibernate.SessionFactory;
import org.hibernate.jdbc.Work;

import com.floreantpos.PosLog;

public class UpdateDBTo360 {

	private SessionFactory sessionFactory;
	private String schemaName;

	public UpdateDBTo360(SessionFactory sessionFactory, String schemaName) {
		this.sessionFactory = sessionFactory;
		this.schemaName = schemaName;
	}

	public void update() throws Exception {
		PosLog.info(getClass(), "Updating : " + schemaName + " schema.");

		sessionFactory.openSession().doWork(new Work() {
			@Override
			public void execute(Connection connection) throws SQLException {
				PosLog.info(getClass(), "Updating : " + schemaName + " schema.");
				Statement updateQueryStatement = connection.createStatement();
				updateQueryStatement.execute(String.format("alter table %s.manufacture rename to manufacturer;", schemaName));
				connection.commit();
			}
		});
	}

}