package com.floreantpos.model.dao;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.OutdoorTicket;
import com.floreantpos.model.Patient;
import com.floreantpos.model.Ticket;
import com.floreantpos.swing.PaginatedListModel;

public class OutdoorTicketDAO extends BaseOutdoorTicketDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public OutdoorTicketDAO() {
	}

	public void loadOutdoorTickets(PaginatedListModel<OutdoorTicket> dataModel, String patientId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(OutdoorTicket.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(patientId)) {
				criteria.add(Restrictions.eq(OutdoorTicket.PROP_CUSTOMER_ID, patientId));
			}

			dataModel.setNumRows(rowCount(criteria));

			criteria.addOrder(Order.desc(OutdoorTicket.PROP_CREATE_DATE));
			criteria.setFirstResult(dataModel.getCurrentRowIndex());
			criteria.setMaxResults(dataModel.getPageSize());
			dataModel.setData(criteria.list());
		}
	}

	public void saveWithPatient(OutdoorTicket outdoorTicket) {
		try (Session session = createNewSession()) {

			Transaction tx = session.beginTransaction();

			if (StringUtils.isBlank(outdoorTicket.getCustomerId())) {
				Patient patient = new Patient();

				patient.setFirstName(outdoorTicket.getCustomerName());
				patient.setDateOfBirth(outdoorTicket.getDateOfBirth());
				patient.setMobileNo(outdoorTicket.getCustomerPhone());
				patient.putPatientGender(outdoorTicket.getCustomerGender());

				PatientDAO.getInstance().save(patient, session);

				outdoorTicket.setCustomerId(patient.getId());
			}

			saveOrUpdate(outdoorTicket, session);

			tx.commit();

		}
	}

	public Ticket saveWithOutdoorOrder(OutdoorTicket outdoorTicket, Ticket ticket) {
		try (Session session = createNewSession()) {

			Transaction tx = session.beginTransaction();

			saveOrUpdate(outdoorTicket, session);

			ticket.setOutdoorTicketId(outdoorTicket.getId());
			TicketDAO.getInstance().saveOrUpdate(ticket, session);

			tx.commit();

			return ticket;
		}
	}

	public OutdoorTicket findByTransactionId(String transactionId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(OutdoorTicket.class);
			
			addDeletedFilter(criteria);
			criteria.add(Restrictions.eq(OutdoorTicket.PROP_TRANSACTION_ID, transactionId));
			
			criteria.addOrder(Order.asc(OutdoorTicket.PROP_CREATE_DATE));
			criteria.setMaxResults(1);

			return (OutdoorTicket) criteria.uniqueResult();
		}
	}

}