package com.floreantpos.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.PosLog;
import com.floreantpos.model.base.BaseDeliveryZone;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

public class DeliveryZone extends BaseDeliveryZone implements TimedModel, PropertyContainer {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	public static final Integer NONE = 0;
	public static final Integer POLYGON = 1;
	public static final Integer CIRCLE = 2;
	public static final String BY_DISTANCE = "By distance"; //$NON-NLS-1$
	public static final String BY_ZIPCODE = "By zipcode"; //$NON-NLS-1$
	public static final String BY_MAP = "By map"; //$NON-NLS-1$
	public static final String JSON_PROP_COORDINATES = "coordinates"; //$NON-NLS-1$

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public DeliveryZone() {
	}

	/**
	 * Constructor for primary key
	 */
	public DeliveryZone(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}
		try {
			propertiesContainer = new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		} catch (Exception e) {
		}
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		try {
			propertiesContainer = new Gson().fromJson(properties, com.google.gson.JsonObject.class);
		} catch (Exception e) {
		}
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	public void setMarker(double lat, double lng) {
		setLatitude(lat);
		setLongitude(lng);
	}

	public List<DeliveryFee> getDeliveryFees(boolean ascOrder) {
		if (!getPropertyStore().has("deliveryFees")) { //$NON-NLS-1$
			return new ArrayList<>();
		}
		List<DeliveryFee> deliveryFees = new ArrayList<>();
		JsonArray jsonArray = getPropertyStore().getAsJsonArray("deliveryFees"); //$NON-NLS-1$
		if (jsonArray.size() > 0) {
			for (int i = 0; i < jsonArray.size(); i++) {
				JsonObject jsonObject = (JsonObject) jsonArray.get(i);
				DeliveryFee deliveryFee = new DeliveryFee();
				deliveryFee.setSubtotalAmount(POSUtil.parseDouble(jsonObject.get("subtotalAmount").getAsString())); //$NON-NLS-1$
				deliveryFee.setLogicalExpression(LogicalExpression.valueOf(jsonObject.get("expression").getAsString())); //$NON-NLS-1$
				deliveryFee.setFeeAmount(POSUtil.parseDouble(jsonObject.get("feeAmount").getAsString())); //$NON-NLS-1$
				deliveryFees.add(deliveryFee);
			}
		}
		if (ascOrder) {
			Collections.sort(deliveryFees, new Comparator<DeliveryFee>() {

				@Override
				public int compare(DeliveryFee o1, DeliveryFee o2) {
					return o1.getSubtotalAmount().compareTo(o2.getSubtotalAmount());
				}
			});
		}
		else {
			Collections.sort(deliveryFees, new Comparator<DeliveryFee>() {

				@Override
				public int compare(DeliveryFee o1, DeliveryFee o2) {
					return o2.getSubtotalAmount().compareTo(o1.getSubtotalAmount());
				}
			});
		}
		return deliveryFees;
	}

	public void setDeliveryFees(List<DeliveryFee> deliveryFees) {
		JsonArray jsonArray = new JsonArray();
		for (DeliveryFee deliveryFee : deliveryFees) {
			jsonArray.add(deliveryFee.toJson());
		}
		getPropertyStore().add("deliveryFees", jsonArray); //$NON-NLS-1$
	}

	public double calculateDeliveryCharge(Double subtotalAmountAfterDiscount) {
		List<DeliveryFee> deliveryFees = getDeliveryFees(false);
		if (deliveryFees != null && deliveryFees.size() > 0) {
			for (DeliveryFee deliveryFee : deliveryFees) {
				if (deliveryFee.getLogicalExpression() == LogicalExpression.GREATER_THAN) {
					if (subtotalAmountAfterDiscount > deliveryFee.getSubtotalAmount()) {
						PosLog.debug(getClass(),
								subtotalAmountAfterDiscount + ">" + deliveryFee.getSubtotalAmount() + " true Fee applied: " + deliveryFee.getFeeAmount()); //$NON-NLS-1$ //$NON-NLS-2$
						return deliveryFee.getFeeAmount();
					}
					PosLog.debug(getClass(), subtotalAmountAfterDiscount + ">" + deliveryFee.getSubtotalAmount() + " false"); //$NON-NLS-1$ //$NON-NLS-2$
				}
			}
			Collections.sort(deliveryFees, new Comparator<DeliveryFee>() {

				@Override
				public int compare(DeliveryFee o1, DeliveryFee o2) {
					return o1.getSubtotalAmount().compareTo(o2.getSubtotalAmount());
				}
			});
			for (DeliveryFee deliveryFee : deliveryFees) {
				if (deliveryFee.getLogicalExpression() == LogicalExpression.LESS_THAN_OR_EQUAL) {
					if (subtotalAmountAfterDiscount <= deliveryFee.getSubtotalAmount()) {
						PosLog.debug(getClass(),
								subtotalAmountAfterDiscount + "<=" + deliveryFee.getSubtotalAmount() + " true Fee applied: " + deliveryFee.getFeeAmount()); //$NON-NLS-1$ //$NON-NLS-2$
						return deliveryFee.getFeeAmount();
					}
					PosLog.debug(getClass(), subtotalAmountAfterDiscount + "<=" + deliveryFee.getSubtotalAmount() + " false"); //$NON-NLS-1$ //$NON-NLS-2$
				}
			}
			return 0D;
		}
		else {
			return getDeliveryCharge();
		}
	}
}