package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the DOCTOR_VISIT table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="DOCTOR_VISIT"
 */

public abstract class BaseDoctorVisit  implements Comparable, Serializable {

	public static String REF = "DoctorVisit"; //$NON-NLS-1$
	public static String PROP_NEXT_FOLLOW_UP_DATE = "nextFollowUpDate"; //$NON-NLS-1$
	public static String PROP_ADMISSION_ID = "admissionId"; //$NON-NLS-1$
	public static String PROP_VISIT_REASON = "visitReason"; //$NON-NLS-1$
	public static String PROP_FEE_PAID_AMOUNT = "feePaidAmount"; //$NON-NLS-1$
	public static String PROP_VISIT_NO = "visitNo"; //$NON-NLS-1$
	public static String PROP_VISIT_DATE = "visitDate"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_PATIENT_ID = "patientId"; //$NON-NLS-1$
	public static String PROP_CREATED_DATE = "createdDate"; //$NON-NLS-1$
	public static String PROP_DOCTOR_FEE = "doctorFee"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseDoctorVisit () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseDoctorVisit (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.util.Date createdDate;
				private java.lang.Integer visitNo;
				private java.lang.String visitReason;
				private java.util.Date visitDate;
				private java.lang.String doctorId;
				private java.lang.Double doctorFee;
				private java.lang.Double feePaidAmount;
				private java.lang.String patientId;
				private java.lang.String admissionId;
				private java.util.Date nextFollowUpDate;
				private java.lang.String properties;
				private java.lang.Boolean deleted;
	
	// collections
	private java.util.List<com.floreantpos.model.DoctorVisitDiagnosisItem> diagnosisItems;
	private java.util.List<com.floreantpos.model.DoctorVisitMedicineItem> medicineItems;
	private java.util.List<String> instructions;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.UUIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: CREATED_DATE
	 */

	public java.util.Date getCreatedDate () {
			return createdDate;
	}



	/**
	 * Set the value related to the column: CREATED_DATE
	 * @param createdDate the CREATED_DATE value
	 */
			public void setCreatedDate (java.util.Date createdDate) {
			this.createdDate = createdDate;
	}



	/**
	 * Return the value associated with the column: VISIT_NO
	 */

	public java.lang.Integer getVisitNo () {
						return visitNo == null ? Integer.valueOf(0) : visitNo;
		}



	/**
	 * Set the value related to the column: VISIT_NO
	 * @param visitNo the VISIT_NO value
	 */
			public void setVisitNo (java.lang.Integer visitNo) {
			this.visitNo = visitNo;
	}



	/**
	 * Return the value associated with the column: VISIT_REASON
	 */

	public java.lang.String getVisitReason () {
			return visitReason;
	}



	/**
	 * Set the value related to the column: VISIT_REASON
	 * @param visitReason the VISIT_REASON value
	 */
			public void setVisitReason (java.lang.String visitReason) {
			this.visitReason = visitReason;
	}



	/**
	 * Return the value associated with the column: VISIT_DATE
	 */

	public java.util.Date getVisitDate () {
			return visitDate;
	}



	/**
	 * Set the value related to the column: VISIT_DATE
	 * @param visitDate the VISIT_DATE value
	 */
			public void setVisitDate (java.util.Date visitDate) {
			this.visitDate = visitDate;
	}



	/**
	 * Return the value associated with the column: DOCTOR_ID
	 */

	public java.lang.String getDoctorId () {
			return doctorId;
	}



	/**
	 * Set the value related to the column: DOCTOR_ID
	 * @param doctorId the DOCTOR_ID value
	 */
			public void setDoctorId (java.lang.String doctorId) {
			this.doctorId = doctorId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_FEE
	 */

	public java.lang.Double getDoctorFee () {
						return doctorFee == null ? Double.valueOf(0) : doctorFee;
		}



	/**
	 * Set the value related to the column: DOCTOR_FEE
	 * @param doctorFee the DOCTOR_FEE value
	 */
			public void setDoctorFee (java.lang.Double doctorFee) {
			this.doctorFee = doctorFee;
	}



	/**
	 * Return the value associated with the column: FEE_PAID_AMOUNT
	 */

	public java.lang.Double getFeePaidAmount () {
						return feePaidAmount == null ? Double.valueOf(0) : feePaidAmount;
		}



	/**
	 * Set the value related to the column: FEE_PAID_AMOUNT
	 * @param feePaidAmount the FEE_PAID_AMOUNT value
	 */
			public void setFeePaidAmount (java.lang.Double feePaidAmount) {
			this.feePaidAmount = feePaidAmount;
	}



	/**
	 * Return the value associated with the column: PATIENT_ID
	 */

	public java.lang.String getPatientId () {
			return patientId;
	}



	/**
	 * Set the value related to the column: PATIENT_ID
	 * @param patientId the PATIENT_ID value
	 */
			public void setPatientId (java.lang.String patientId) {
			this.patientId = patientId;
	}



	/**
	 * Return the value associated with the column: ADMISSION_ID
	 */

	public java.lang.String getAdmissionId () {
			return admissionId;
	}



	/**
	 * Set the value related to the column: ADMISSION_ID
	 * @param admissionId the ADMISSION_ID value
	 */
			public void setAdmissionId (java.lang.String admissionId) {
			this.admissionId = admissionId;
	}



	/**
	 * Return the value associated with the column: NEX_FOLLOWUP_DATE
	 */

	public java.util.Date getNextFollowUpDate () {
			return nextFollowUpDate;
	}



	/**
	 * Set the value related to the column: NEX_FOLLOWUP_DATE
	 * @param nextFollowUpDate the NEX_FOLLOWUP_DATE value
	 */
			public void setNextFollowUpDate (java.util.Date nextFollowUpDate) {
			this.nextFollowUpDate = nextFollowUpDate;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: diagnosisItems
	 */

	public java.util.List<com.floreantpos.model.DoctorVisitDiagnosisItem> getDiagnosisItems () {
			return diagnosisItems;
	}



	/**
	 * Set the value related to the column: diagnosisItems
	 * @param diagnosisItems the diagnosisItems value
	 */
			public void setDiagnosisItems (java.util.List<com.floreantpos.model.DoctorVisitDiagnosisItem> diagnosisItems) {
			this.diagnosisItems = diagnosisItems;
	}

	public void addTodiagnosisItems (com.floreantpos.model.DoctorVisitDiagnosisItem doctorVisitDiagnosisItem) {
		if (null == getDiagnosisItems()) setDiagnosisItems(new java.util.ArrayList<com.floreantpos.model.DoctorVisitDiagnosisItem>());
		getDiagnosisItems().add(doctorVisitDiagnosisItem);
	}



	/**
	 * Return the value associated with the column: medicineItems
	 */

	public java.util.List<com.floreantpos.model.DoctorVisitMedicineItem> getMedicineItems () {
			return medicineItems;
	}



	/**
	 * Set the value related to the column: medicineItems
	 * @param medicineItems the medicineItems value
	 */
			public void setMedicineItems (java.util.List<com.floreantpos.model.DoctorVisitMedicineItem> medicineItems) {
			this.medicineItems = medicineItems;
	}

	public void addTomedicineItems (com.floreantpos.model.DoctorVisitMedicineItem doctorVisitMedicineItem) {
		if (null == getMedicineItems()) setMedicineItems(new java.util.ArrayList<com.floreantpos.model.DoctorVisitMedicineItem>());
		getMedicineItems().add(doctorVisitMedicineItem);
	}



	/**
	 * Return the value associated with the column: instructions
	 */

	public java.util.List<String> getInstructions () {
			return instructions;
	}



	/**
	 * Set the value related to the column: instructions
	 * @param instructions the instructions value
	 */
			public void setInstructions (java.util.List<String> instructions) {
			this.instructions = instructions;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.DoctorVisit)) return false;
		else {
			com.floreantpos.model.DoctorVisit doctorVisit = (com.floreantpos.model.DoctorVisit) obj;
			if (null == this.getId() || null == doctorVisit.getId()) return this == obj;
			else return (this.getId().equals(doctorVisit.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}