package com.floreantpos.model.ext;

import org.apache.commons.lang.StringUtils;

public enum OutdoorTicketStatus {
	//@formatter:off
	PENDING("Pending"), 
	PAID("Paid"), 
	//CONFIRM("Confirm"), 
	COMPLETE("Complete"), 
	CANCEL("Cancel"), 
	; 

	//@formatter:on

	private String outdoorTicketStatusName;

	private OutdoorTicketStatus(String status) {
		this.outdoorTicketStatusName = status;
	}

	public static OutdoorTicketStatus fromString(String status) {
		if (StringUtils.isBlank(status)) {
			return PENDING;
		}
		OutdoorTicketStatus[] statusList = values();
		for (OutdoorTicketStatus outdoorTicketStatus : statusList) {
			if (outdoorTicketStatus.name().equals(status)) {
				return outdoorTicketStatus;
			}
		}
		return PENDING;
	}

	public String getDisplayName() {
		return outdoorTicketStatusName;
	}

	@Override
	public String toString() {
		return getDisplayName();
	}
}
