package com.floreantpos.model;

import com.floreantpos.model.base.BaseTicketPaymentAllocation;

public class TicketPaymentAllocation extends BaseTicketPaymentAllocation {
	private static final long serialVersionUID = 1L;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TicketPaymentAllocation() {
	}

	/**
	 * Constructor for primary key
	 */
	public TicketPaymentAllocation(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public static TicketPaymentAllocation createTicketPaymentAllocation(Ticket ticket, PosTransaction transaction) {
		TicketPaymentAllocation ticketPaymentAllocation = new TicketPaymentAllocation();

		ticketPaymentAllocation.setPaymentToTicketId(ticket.getId());

		ticketPaymentAllocation.setOutletId(transaction.getOutletId());
		ticketPaymentAllocation.setTransactionId(transaction.getId());
		ticketPaymentAllocation.setTransactionTime(transaction.getTransactionTime());
		ticketPaymentAllocation.setAmount(transaction.getAmount());

		return ticketPaymentAllocation;
	}

}