package com.floreantpos.model.dao;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.TicketPaymentAllocation;

public class TicketPaymentAllocationDAO extends BaseTicketPaymentAllocationDAO {

	public TicketPaymentAllocation findTicketPaymentAllocationBy(String transactionId) {

		try (Session session = createNewSession()) {

			Criteria criteria = session.createCriteria(TicketPaymentAllocation.class);
			addDeletedFilter(criteria);

			if (StringUtils.isNotBlank(transactionId)) {
				criteria.add(Restrictions.eq(TicketPaymentAllocation.PROP_TRANSACTION_ID, transactionId));
			}
			criteria.setMaxResults(1);

			return (TicketPaymentAllocation) criteria.uniqueResult();

		}
	}

}