package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseTicketPaymentAllocation;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown = true)
public class TicketPaymentAllocation extends BaseTicketPaymentAllocation implements TimedModel, PropertyContainer2 {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	private transient JsonObject propertiesContainer;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TicketPaymentAllocation() {
	}

	/**
	 * Constructor for primary key
	 */
	public TicketPaymentAllocation(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	@Override
	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	@Override
	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	@Override
	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public static TicketPaymentAllocation createTicketPaymentAllocation(Ticket ticket, PosTransaction transaction) {
		TicketPaymentAllocation ticketPaymentAllocation = new TicketPaymentAllocation();

		ticketPaymentAllocation.setPaymentToTicketId(ticket.getId());

		ticketPaymentAllocation.setOutletId(transaction.getOutletId());
		ticketPaymentAllocation.setTransactionId(transaction.getId());
		ticketPaymentAllocation.setTransactionTime(transaction.getTransactionTime());
		ticketPaymentAllocation.setPaymentTypeString(transaction.getPaymentTypeString());
		ticketPaymentAllocation.setAmount(transaction.getAmount());

		return ticketPaymentAllocation;
	}

}