package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the OUTDOOR_TICKET table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="OUTDOOR_TICKET"
 */

public abstract class BaseOutdoorTicket  implements Comparable, Serializable {

	public static String REF = "OutdoorTicket"; //$NON-NLS-1$
	public static String PROP_STATUS = "status"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_GENDER = "customerGender"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_AGE = "customerAge"; //$NON-NLS-1$
	public static String PROP_PRESCRIPTION_ID = "prescriptionId"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_ID = "customerId"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_CREATE_DATE = "createDate"; //$NON-NLS-1$
	public static String PROP_APPOINTMENT_DATE = "appointmentDate"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_ID = "transactionId"; //$NON-NLS-1$
	public static String PROP_DOCTOR_ID = "doctorId"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_PHONE = "customerPhone"; //$NON-NLS-1$
	public static String PROP_TOKEN_NO = "tokenNo"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_EMAIL = "customerEmail"; //$NON-NLS-1$
	public static String PROP_CLOSING_DATE = "closingDate"; //$NON-NLS-1$
	public static String PROP_CUSTOMER_NAME = "customerName"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$


	// constructors
	public BaseOutdoorTicket () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseOutdoorTicket (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.lang.String outletId;
				private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.Integer tokenNo;
				private java.util.Date createDate;
				private java.util.Date closingDate;
				private java.util.Date appointmentDate;
				private java.lang.String status;
				private java.lang.String transactionId;
				private java.lang.String doctorId;
				private java.lang.String customerId;
				private java.lang.String customerName;
				private java.lang.String customerPhone;
				private java.lang.String customerEmail;
				private java.lang.String customerGender;
				private java.lang.String customerAge;
				private java.lang.String prescriptionId;
				private java.lang.String properties;
	


	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.OutdoorTicketIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: TOKEN_NO
	 */

	public java.lang.Integer getTokenNo () {
						return tokenNo == null ? Integer.valueOf(0) : tokenNo;
		}



	/**
	 * Set the value related to the column: TOKEN_NO
	 * @param tokenNo the TOKEN_NO value
	 */
			public void setTokenNo (java.lang.Integer tokenNo) {
			this.tokenNo = tokenNo;
	}



	/**
	 * Return the value associated with the column: CREATE_DATE
	 */

	public java.util.Date getCreateDate () {
			return createDate;
	}



	/**
	 * Set the value related to the column: CREATE_DATE
	 * @param createDate the CREATE_DATE value
	 */
			public void setCreateDate (java.util.Date createDate) {
			this.createDate = createDate;
	}



	/**
	 * Return the value associated with the column: CLOSING_DATE
	 */

	public java.util.Date getClosingDate () {
			return closingDate;
	}



	/**
	 * Set the value related to the column: CLOSING_DATE
	 * @param closingDate the CLOSING_DATE value
	 */
			public void setClosingDate (java.util.Date closingDate) {
			this.closingDate = closingDate;
	}



	/**
	 * Return the value associated with the column: APPOINTMENT_DATE
	 */

	public java.util.Date getAppointmentDate () {
			return appointmentDate;
	}



	/**
	 * Set the value related to the column: APPOINTMENT_DATE
	 * @param appointmentDate the APPOINTMENT_DATE value
	 */
			public void setAppointmentDate (java.util.Date appointmentDate) {
			this.appointmentDate = appointmentDate;
	}



	/**
	 * Return the value associated with the column: STATUS
	 */

	public java.lang.String getStatus () {
			return status;
	}



	/**
	 * Set the value related to the column: STATUS
	 * @param status the STATUS value
	 */
			public void setStatus (java.lang.String status) {
			this.status = status;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_ID
	 */

	public java.lang.String getTransactionId () {
			return transactionId;
	}



	/**
	 * Set the value related to the column: TRANSACTION_ID
	 * @param transactionId the TRANSACTION_ID value
	 */
			public void setTransactionId (java.lang.String transactionId) {
			this.transactionId = transactionId;
	}



	/**
	 * Return the value associated with the column: DOCTOR_ID
	 */

	public java.lang.String getDoctorId () {
			return doctorId;
	}



	/**
	 * Set the value related to the column: DOCTOR_ID
	 * @param doctorId the DOCTOR_ID value
	 */
			public void setDoctorId (java.lang.String doctorId) {
			this.doctorId = doctorId;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_ID
	 */

	public java.lang.String getCustomerId () {
			return customerId;
	}



	/**
	 * Set the value related to the column: CUSTOMER_ID
	 * @param customerId the CUSTOMER_ID value
	 */
			public void setCustomerId (java.lang.String customerId) {
			this.customerId = customerId;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_NAME
	 */

	public java.lang.String getCustomerName () {
			return customerName;
	}



	/**
	 * Set the value related to the column: CUSTOMER_NAME
	 * @param customerName the CUSTOMER_NAME value
	 */
			public void setCustomerName (java.lang.String customerName) {
			this.customerName = customerName;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_PHONE
	 */

	public java.lang.String getCustomerPhone () {
			return customerPhone;
	}



	/**
	 * Set the value related to the column: CUSTOMER_PHONE
	 * @param customerPhone the CUSTOMER_PHONE value
	 */
			public void setCustomerPhone (java.lang.String customerPhone) {
			this.customerPhone = customerPhone;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_EMAIL
	 */

	public java.lang.String getCustomerEmail () {
			return customerEmail;
	}



	/**
	 * Set the value related to the column: CUSTOMER_EMAIL
	 * @param customerEmail the CUSTOMER_EMAIL value
	 */
			public void setCustomerEmail (java.lang.String customerEmail) {
			this.customerEmail = customerEmail;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_GENDER
	 */

	public java.lang.String getCustomerGender () {
			return customerGender;
	}



	/**
	 * Set the value related to the column: CUSTOMER_GENDER
	 * @param customerGender the CUSTOMER_GENDER value
	 */
			public void setCustomerGender (java.lang.String customerGender) {
			this.customerGender = customerGender;
	}



	/**
	 * Return the value associated with the column: CUSTOMER_AGE
	 */

	public java.lang.String getCustomerAge () {
			return customerAge;
	}



	/**
	 * Set the value related to the column: CUSTOMER_AGE
	 * @param customerAge the CUSTOMER_AGE value
	 */
			public void setCustomerAge (java.lang.String customerAge) {
			this.customerAge = customerAge;
	}



	/**
	 * Return the value associated with the column: PRESCRIPTION_ID
	 */

	public java.lang.String getPrescriptionId () {
			return prescriptionId;
	}



	/**
	 * Set the value related to the column: PRESCRIPTION_ID
	 * @param prescriptionId the PRESCRIPTION_ID value
	 */
			public void setPrescriptionId (java.lang.String prescriptionId) {
			this.prescriptionId = prescriptionId;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.OutdoorTicket)) return false;
		else {
			com.floreantpos.model.OutdoorTicket outdoorTicket = (com.floreantpos.model.OutdoorTicket) obj;
			if (null == this.getId() || null == outdoorTicket.getId()) return this == obj;
			else return (this.getId().equals(outdoorTicket.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}