package com.floreantpos.model.base;

import java.io.Serializable;


/**
 * This is an object that contains data related to the TICKET_PAYMENT_ALLOCATION table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="TICKET_PAYMENT_ALLOCATION"
 */

public abstract class BaseTicketPaymentAllocation  implements Serializable {

	public static String REF = "TicketPaymentAllocation"; //$NON-NLS-1$
	public static String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$
	public static String PROP_TICKET = "ticket"; //$NON-NLS-1$
	public static String PROP_VOID_DATE = "voidDate"; //$NON-NLS-1$
	public static String PROP_AMOUNT = "amount"; //$NON-NLS-1$
	public static String PROP_PROPERTIES = "properties"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_ID = "transactionId"; //$NON-NLS-1$
	public static String PROP_TRANSACTION_TIME = "transactionTime"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_PAYMENT_TO_TICKET_ID = "paymentToTicketId"; //$NON-NLS-1$
	public static String PROP_PAYMENT_TYPE_STRING = "paymentTypeString"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_VOIDED = "voided"; //$NON-NLS-1$


	// constructors
	public BaseTicketPaymentAllocation () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseTicketPaymentAllocation (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String outletId;
				private java.lang.String paymentToTicketId;
				private java.lang.String transactionId;
				private java.util.Date transactionTime;
				private java.lang.Double amount;
				private java.lang.String paymentTypeString;
				private java.lang.String properties;
				private java.lang.Boolean voided;
				private java.util.Date voidDate;
				private java.lang.Boolean deleted;
	
	// many to one
	private com.floreantpos.model.Ticket ticket;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.GlobalIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: OUTLET_ID
	 */

	public java.lang.String getOutletId () {
			return outletId;
	}



	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
			public void setOutletId (java.lang.String outletId) {
			this.outletId = outletId;
	}



	/**
	 * Return the value associated with the column: PAYMENT_TO_TICKET_ID
	 */

	public java.lang.String getPaymentToTicketId () {
			return paymentToTicketId;
	}



	/**
	 * Set the value related to the column: PAYMENT_TO_TICKET_ID
	 * @param paymentToTicketId the PAYMENT_TO_TICKET_ID value
	 */
			public void setPaymentToTicketId (java.lang.String paymentToTicketId) {
			this.paymentToTicketId = paymentToTicketId;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_ID
	 */

	public java.lang.String getTransactionId () {
			return transactionId;
	}



	/**
	 * Set the value related to the column: TRANSACTION_ID
	 * @param transactionId the TRANSACTION_ID value
	 */
			public void setTransactionId (java.lang.String transactionId) {
			this.transactionId = transactionId;
	}



	/**
	 * Return the value associated with the column: TRANSACTION_TIME
	 */

	public java.util.Date getTransactionTime () {
			return transactionTime;
	}



	/**
	 * Set the value related to the column: TRANSACTION_TIME
	 * @param transactionTime the TRANSACTION_TIME value
	 */
			public void setTransactionTime (java.util.Date transactionTime) {
			this.transactionTime = transactionTime;
	}



	/**
	 * Return the value associated with the column: AMOUNT
	 */

	public java.lang.Double getAmount () {
						return amount == null ? Double.valueOf(0) : amount;
		}



	/**
	 * Set the value related to the column: AMOUNT
	 * @param amount the AMOUNT value
	 */
			public void setAmount (java.lang.Double amount) {
			this.amount = amount;
	}



	/**
	 * Return the value associated with the column: PAYMENT_TYPE
	 */

	public java.lang.String getPaymentTypeString () {
			return paymentTypeString;
	}



	/**
	 * Set the value related to the column: PAYMENT_TYPE
	 * @param paymentTypeString the PAYMENT_TYPE value
	 */
			public void setPaymentTypeString (java.lang.String paymentTypeString) {
			this.paymentTypeString = paymentTypeString;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */

	public java.lang.String getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
			public void setProperties (java.lang.String properties) {
			this.properties = properties;
	}



	/**
	 * Return the value associated with the column: VOIDED
	 */

	public java.lang.Boolean isVoided () {
					return voided == null ? Boolean.FALSE : voided;
		}

	public java.lang.Boolean getVoided () {
				return voided == null ? Boolean.FALSE : voided;
			}


	/**
	 * Set the value related to the column: VOIDED
	 * @param voided the VOIDED value
	 */
			public void setVoided (java.lang.Boolean voided) {
			this.voided = voided;
	}



	/**
	 * Return the value associated with the column: VOID_DATE
	 */

	public java.util.Date getVoidDate () {
			return voidDate;
	}



	/**
	 * Set the value related to the column: VOID_DATE
	 * @param voidDate the VOID_DATE value
	 */
			public void setVoidDate (java.util.Date voidDate) {
			this.voidDate = voidDate;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: TICKET_OUTLET_ID
	 */

	public com.floreantpos.model.Ticket getTicket () {
			return ticket;
	}



	/**
	 * Set the value related to the column: TICKET_OUTLET_ID
	 * @param ticket the TICKET_OUTLET_ID value
	 */
			public void setTicket (com.floreantpos.model.Ticket ticket) {
			this.ticket = ticket;
	}




	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.TicketPaymentAllocation)) return false;
		else {
			com.floreantpos.model.TicketPaymentAllocation ticketPaymentAllocation = (com.floreantpos.model.TicketPaymentAllocation) obj;
			if (null == this.getId() || null == ticketPaymentAllocation.getId()) return this == obj;
			else return (this.getId().equals(ticketPaymentAllocation.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}