package com.floreantpos.model.util.pricecalc;

import java.lang.reflect.Method;

public class DiscountCalcFactory {
	private static DiscountCalculator discountCalc;

	public static DiscountCalculator getCalc() {
		try {
			if (discountCalc != null) {
				return discountCalc;
			}

			Class<?> clazz = Class.forName("com.orocube.pos.pricecalc.DiscountCalc"); //$NON-NLS-1$
			Method method = clazz.getMethod("getInstance"); //$NON-NLS-1$
			discountCalc = (DiscountCalculator) method.invoke(null);
			return discountCalc;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

}
