package com.floreantpos.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang3.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseDoctorVisitDiagnosisItem;
import com.floreantpos.model.dao.MenuItemDAO;

@JsonIgnoreProperties(ignoreUnknown = true, value = {"doctorVisit"})
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
public class DoctorVisitDiagnosisItem extends BaseDoctorVisitDiagnosisItem {
	private static final long serialVersionUID = 1L;

	private transient MenuItem testItem;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public DoctorVisitDiagnosisItem() {
	}

	/**
	 * Constructor for primary key
	 */
	public DoctorVisitDiagnosisItem(java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public DoctorVisitDiagnosisItem(java.lang.String id, com.floreantpos.model.DoctorVisit doctorVisit) {

		super(id, doctorVisit);
	}

	/*[CONSTRUCTOR MARKER END]*/
	public String getName() {
		if (testItem != null) {
			return testItem.getDisplayName();
		}
		if (StringUtils.isBlank(super.getTestItemId())) {
			return "";
		}
		testItem = MenuItemDAO.getInstance().get(super.getTestItemId());
		return testItem == null ? "" : testItem.getDisplayName();
	}

	public void setTestItem(MenuItem item) {
		this.testItem = item;
	}

}