package com.floreantpos.model;

import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseOutdoorTicket;
import com.floreantpos.model.ext.OutdoorTicketStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.GsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown = true)
public class OutdoorTicket extends BaseOutdoorTicket implements TimedModel, PropertyContainer2, IVisit {
	private static final long serialVersionUID = 1L;

	private transient com.google.gson.JsonObject propertiesContainer;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public OutdoorTicket() {
	}

	/**
	 * Constructor for primary key
	 */
	public OutdoorTicket(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer != null) {
			return propertiesContainer;
		}

		String jsonProperties = super.getProperties();
		if (StringUtils.isEmpty(jsonProperties)) {
			propertiesContainer = new JsonObject();
		}
		else {
			propertiesContainer = new Gson().fromJson(jsonProperties, JsonObject.class);
		}
		return propertiesContainer;
	}

	public void putCustomer(Patient patient) {
		if (patient == null) {
			setCustomerId(null);
			setCustomerName(null);
			setCustomerPhone(null);
			setCustomerEmail(null);
			setCustomerGender(null);
			setCustomerAge(null);
			return;
		}

		setCustomerId(patient.getId());
		setCustomerName(patient.getName());
		setCustomerPhone(patient.getMobileNo());
		setCustomerEmail(patient.getEmail());
		setCustomerGender(patient.getPatientGender());
		putDateOfBirth(patient.getDateOfBirth());

	}

	@JsonIgnore
	@XmlTransient
	public Date getDateOfBirth() {
		return getDateProperty("date.of.birth");
	}

	public void putDateOfBirth(Date dateOfBirth) {
		addDateProperty("date.of.birth", dateOfBirth);
	}

	@JsonIgnore
	@XmlTransient
	public String getCreateDateDisplayString() {
		return DateUtil.formatReportDateWithBrowserTimeOffset(getCreateDate());
	}

	@JsonIgnore
	@XmlTransient
	public double getPrice() {
		return getDoubleProperty("outdoor_ticket_item_price");
	}

	public void putPrice(double outdoorItemPrice) {
		addProperty("outdoor_ticket_item_price", String.valueOf(outdoorItemPrice)); //$NON-NLS-1$
	}

	@JsonIgnore
	@XmlTransient
	public String getStatusDisplayName() {
		OutdoorTicketStatus status = OutdoorTicketStatus.fromString(getStatus());
		return status.getDisplayName();
	}

	@XmlTransient
	@JsonIgnore
	@Override
	public List<String> getProblems() {
		return GsonUtil.convertJSONToList(getProperty("problems", "[]"), String.class);
	}

	public void putProblems(List<String> problems) {
		addProperty("problems", GsonUtil.createGson().toJson(problems));
	}

	@XmlTransient
	@JsonIgnore
	@Override
	public String getNotes() {
		return getProperty("notes");
	}

	@Override
	public void putNotes(String notes) {
		addProperty("notes", notes);
	}

	@XmlTransient
	@JsonIgnore
	public String getDoctorNameDisplay() {
		String doctorId = getDoctorId();
		if (StringUtils.isNotBlank(doctorId)) {
			Doctor doctor = (Doctor) DataProvider.get().getObjectOf(Doctor.class, doctorId);
			if (doctor != null) {
				return doctor.getName();
			}
		}
		return StringUtils.EMPTY;
	}
}