package com.floreantpos.model;

import java.awt.Color;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.constants.AppConstants;
import com.floreantpos.model.base.BaseOutlet;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.OutdoorConfigurationFeeType;
import com.floreantpos.util.CashRoundingRule;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "properties", "departments", "tableServingBGColor", "tableServingForeColor", "tableBookForeColor",
		"tableBookBGColor", "tableFreeForeColor", "tableFreeBGColor", "tableSeatForeColor", "tableSeatBGColor", "taxGroup", "address", "currency",
		"workingHours", "timeZone", "setupComplete" })
@XmlRootElement
public class Outlet extends BaseOutlet implements TimedModel, PropertyContainer, AddressContainer {
	private static final long serialVersionUID = 1L;

	//public final static String PROP_KDS_ENABLED = "kds_enable";

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;
	private transient JsonObject propertiesContainer;

	public static final String REPORT_PAPER_SIZE = "report_paper_size"; //$NON-NLS-1$
	public static final String PRINT_GROUP_IN_REPORT = "print_group_in_report"; //$NON-NLS-1$
	public static final String REPORT_PRINT_HEADER = "print_report_header"; //$NON-NLS-1$
	//public static final String REPORT_IMAGE_PREVIEW = "report.image_preview"; //$NON-NLS-1$
	public static final String PRINT_LAB_TEST_FOOTET_IN_REPORT = "print_lab_test_footer_in_report"; //$NON-NLS-1$
	public static final String PRINT_LAB_TEST_TECHNICIAN_IN_REPORT = "print_lab_test_technician_in_report"; //$NON-NLS-1$
	public static final String PRINT_LAB_TEST_INCHARGE_IN_REPORT = "print_lab_test_incharge_in_report"; //$NON-NLS-1$
	public static final String PRINT_LAB_DOCTOR_IN_REPORT = "print_lab_doctor_in_report"; //$NON-NLS-1$

	public static final String RECEIPT_PAPER_SIZE = "receipt.paper_size"; //$NON-NLS-1$
	public static final String RECEIPT_PRINT_HEADER = "receipt.print_header"; //$NON-NLS-1$
	public static final String RECEIPT_IMAGE_PREVIEW = "receipt.image_preview"; //$NON-NLS-1$

	//public static final String SHOW_AGNENT_COMMISSION_IN_TICKET_GRID = "show_agent_commission_in_ticket_grid"; //$NOTN-NLS-1$

	private List<WorkingHours> workingHours;

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public Outlet() {
	}

	/**
	 * Constructor for primary key
	 */
	public Outlet(java.lang.String id) {
		super(id);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		return super.getName();
	}

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	@XmlTransient
	public TaxGroup getTaxGroup() {
		return TaxGroupDAO.getInstance().get(getTaxGroupId(), getId());
	}

	public void setTaxGroup(TaxGroup taxGroup) {
		String taxGroupId = null;
		if (taxGroup != null) {
			taxGroupId = taxGroup.getId();
		}
		super.setTaxGroupId(taxGroupId);
	}

	@XmlTransient
	public Address getAddress() {
		//		if (StringUtils.isNotEmpty(getAddressId())) {
		//			return AddressDAO.getInstance().get(getAddressId());
		//		}
		//		return null;

		Address address = new Address();
		CopyUtil.copyAddress(this, address);
		return address;
	}

	public void setAddress(Address address) {
		//		String addressId = null;
		//		if (address != null) {
		//			addressId = address.getId();
		//		}
		//		super.setAddressId(addressId);
	}

	@XmlTransient
	public Currency getCurrency() {
		return DataProvider.get().getCurrency(getCurrencyId(), getId());
	}

	public void setCurrency(Currency currency) {
		String currencyId = null;
		if (currency != null) {
			currencyId = currency.getId();
		}
		super.setCurrencyId(currencyId);
	}

	@Override
	public JsonObject getPropertyStore() {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		return propertiesContainer;
	}

	//	public String getCurrencyName() {
	//		String currencyName = super.getCurrencyName();
	//		if (StringUtils.isEmpty(currencyName)) {
	//			return "Sample Currency"; //$NON-NLS-1$
	//		}
	//		return currencyName;
	//	}
	//
	//	public String getCurrencySymbol() {
	//		String currencySymbol = super.getCurrencySymbol();
	//		if (StringUtils.isEmpty(currencySymbol)) {
	//			currencySymbol = "$"; //$NON-NLS-1$
	//		}
	//		return currencySymbol;
	//	}

	//	public boolean isAllwMemberbasedPOI() {
	//		String update = getProperty(AppConstants.INVENTORY_ALLOW_MEMBER_POI);
	//		if (StringUtils.isEmpty(update)) {
	//			return false;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public boolean isUpdateOnHandBlncForSale() {
	//		String update = getProperty(AppConstants.INVENTORY_UPDATE_ON_HAND_BALANCE_FOR_SALE);
	//		if (StringUtils.isEmpty(update)) {
	//			return true;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public boolean isUpdateAvlBlncForSale() {
	//		String update = getProperty(AppConstants.INVENTORY_UPDATE_AVAIL_BALANCE_FOR_SALE);
	//		if (StringUtils.isEmpty(update)) {
	//			return true;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public boolean isAllwNegOnHandBlnce() {
	//		String update = getProperty(AppConstants.INVENTORY_ALLOW_NEGETIVE_ON_HAND_BALANCE);
	//		if (StringUtils.isEmpty(update)) {
	//			return false;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public boolean isUpdateAvlBlncForPOCreated() {
	//		String update = getProperty(AppConstants.INVENTORY_UPDATE_AVAILABLE_BALANCE_FOR_PURCHASE_ORDER_CREATED);
	//		if (StringUtils.isEmpty(update)) {
	//			return false;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public boolean isUpdateOnHandBlncForPORec() {
	//		String update = getProperty(AppConstants.INVENTORY_UPDATE_ON_HAND_BALANCE_FOR_PURCHASE_ORDER_RECEIVED);
	//		if (StringUtils.isEmpty(update)) {
	//			return true;
	//		}
	//		return Boolean.valueOf(update);
	//	}
	//
	//	public String getImageId() {
	//		String storeLogoResourceId = getProperty(AppConstants.PROP_HEADER_LOGO_IMAGE_ID);
	//		if (StringUtils.isEmpty(storeLogoResourceId)) {
	//			String oldLogoResourceId = getProperty("ticket.header.logo.imageid"); //property name changed: ticket.header.logo.imageid-> logo.imageid //$NON-NLS-1$
	//			if (oldLogoResourceId != null) {
	//				addProperty(AppConstants.PROP_HEADER_LOGO_IMAGE_ID, oldLogoResourceId);//old image id replace with current image id
	//				return oldLogoResourceId;
	//			}
	//		}
	//		return storeLogoResourceId;
	//	}
	//
	//	public ImageIcon getStoreLogo() {
	//		if (this.storeLogo == null) {
	//			String storeLogoResourceId = getImageId();
	//			if (StringUtils.isEmpty(storeLogoResourceId))
	//				return null;
	//			ImageResource logoResource = ImageResourceDAO.getInstance().findById(storeLogoResourceId);
	//			if (logoResource != null) {
	//				this.storeLogo = new ImageIcon(logoResource.getImage());
	//				if (this.storeLogo.getIconWidth() > 128 || this.storeLogo.getIconHeight() > 128) {
	//					this.storeLogo = new ImageIcon(POSUtil.getScaledImage(logoResource.getImage(), 128, 128));
	//				}
	//			}
	//		}
	//		return this.storeLogo;
	//	}

	//	public boolean isInventoryAvgPricingMethod() {
	//		String property = getProperty(AppConstants.INVENTORY_PRICING_METHOD);
	//		if (property == null) {
	//			return false;
	//		}
	//		return property.equals(AppConstants.INVENTORY_PRICING_METHOD_VALUE_AVG);
	//	}

	//	public void setStoreLogo(ImageIcon storeLogo) {
	//		this.storeLogo = storeLogo;
	//	}
	//
	//	public ImageIcon getLoginScreenBackground() {
	//		if (this.loginScreenBackground == null) {
	//			String resourceId = getProperty(AppConstants.PROP_LOGIN_SCREEN_BACKGROUND);
	//			if (resourceId == null)
	//				return null;
	//			ImageResource resource = ImageResourceDAO.getInstance().findById(resourceId);
	//			if (resource != null) {
	//				this.loginScreenBackground = new ImageIcon(resource.getImage());
	//			}
	//		}
	//		return loginScreenBackground;
	//	}
	//
	//	public void setLoginScreenBackground(ImageIcon loginScreenBackground) {
	//		this.loginScreenBackground = loginScreenBackground;
	//	}

	//	public static String getWebServiceUrl() {
	//		Store store = DataProvider.get().getStore();
	//		return store.getProperty(RestConstants.WEB_SERVICE_URL) + RestConstants.URL_SERVICE_DATA_STORE
	//				+ store.getProperty(RestConstants.WEB_SERVICE_SCHEMA_NAME); //$NON-NLS-1$
	//	}
	//
	//	public TipsReceivedBy getTipsReceivedByForDeliveryOrder() {
	//		try {
	//			String tipsReceiver = getProperty(AppConstants.TIPS_RECEIVED_BY_FOR_DELIVERY);
	//			if (StringUtils.isNotEmpty(tipsReceiver)) {
	//				return TipsReceivedBy.valueOf(tipsReceiver);
	//			}
	//			return TipsReceivedBy.Server;
	//		} catch (Exception e) {
	//			throw new PosException(Messages.getString("Outlet.2")); //$NON-NLS-1$
	//		}
	//	}
	//
	//	public TipsReceivedBy getTipsReceivedByForNonDeliveryOrder() {
	//		try {
	//			String tipsReceiver = getProperty(AppConstants.TIPS_RECEIVED_BY_FOR_NON_DELIVERY);
	//			if (StringUtils.isNotEmpty(tipsReceiver)) {
	//				return TipsReceivedBy.valueOf(tipsReceiver);
	//			}
	//			return TipsReceivedBy.Server;
	//		} catch (Exception e) {
	//			throw new PosException(Messages.getString("Outlet.2")); //$NON-NLS-1$
	//		}
	//	}
	//
	//	public double getOvertimeMarkup() {
	//		try {
	//			String overtimeMarkup = getProperty(AppConstants.STORE_OVERTIME_MARKUP);
	//			if (StringUtils.isNotEmpty(overtimeMarkup)) {
	//				return Double.parseDouble(overtimeMarkup);
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//		return 0.0;
	//	}
	//
	//	public boolean hasCreateMemberPermission() {
	//		try {
	//			String memberCreate = getProperty(AppConstants.PROP_PERMISSION_CREATE_MEMBER);
	//			if (StringUtils.isNotEmpty(memberCreate)) {
	//				return Boolean.valueOf(memberCreate);
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//		return true;
	//	}
	//
	//	public boolean isAutoSyncCharges() {
	//		return getBooleanProperty(Store.STORE_PROP_AUTOMATICALLY_SYNC_CHARGES_WHEN_DAY_CLOSED, Boolean.FALSE);
	//	}
	//
	//	public boolean isAllowPenyRounding() {
	//		try {
	//			String penyRoundAmnt = getProperty(AppConstants.STORE_PENY_ROUNDING);
	//			if (StringUtils.isNotEmpty(penyRoundAmnt)) {
	//				return Boolean.valueOf(penyRoundAmnt);
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//		return false;
	//	}
	//
	//	public int getCustomerMonitorDisplayOption() {
	//		try {
	//			String displayOptionString = getProperty(AppConstants.CUSTOMER_MONITOR_DIS_OPTION);
	//			if (StringUtils.isNotEmpty(displayOptionString)) {
	//				return Integer.parseInt(displayOptionString);
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//		return 0;
	//	}
	//
	//	public int getCustomerMonitorDisplaySlideDuration() {
	//		try {
	//			String slideDurationString = getProperty(AppConstants.CUSTOMER_MONITOR_SLIDE_DURATION);
	//			if (StringUtils.isNotEmpty(slideDurationString)) {
	//				return Integer.parseInt(slideDurationString);
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//		return 5;
	//	}
	//
	//	public String getServerUrl() {
	//
	//		try {
	//			String serverUrl = getProperty(AppConstants.PROP_UPDATE_SERVER_URL);
	//			if (StringUtils.isNotEmpty(serverUrl)) {
	//				return serverUrl;
	//			}
	//
	//		} catch (Exception e) {
	//		}
	//
	//		return ""; //$NON-NLS-1$
	//	}

	public void setTablePrimaryFontSize(int priFont) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE, String.valueOf(priFont));
	}

	//	public int getTablePrimaryFontSize() {
	//		return getProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE) == null ? 18
	//				: Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_PRIMARY_FONT_SIZE));
	//	}

	public void setTableSecondaryFontSize(int secFont) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE, String.valueOf(secFont));
	}

	//	public int getTableSecondaryFontSize() {
	//		return getProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE) == null ? 10
	//				: Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SECONDARY_FONT_SIZE));
	//	}

	public void setTableBtnWidth(int btnWidth) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH, String.valueOf(btnWidth));
	}

	//	public int getTableBtnWidth() {
	//		return getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH) == null ? 100 : Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_WIDTH));
	//	}

	public void setTableBtnHeight(int btnHeight) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT, String.valueOf(btnHeight));
	}

	//	public int getTableBtnHeight() {
	//		return getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT) == null ? 80 : Integer.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_BTN_HEIGHT));
	//	}

	public void setTableSeatForeColor(Color seatForeColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_FORE_COLOR, seatForeColor != null ? String.valueOf(seatForeColor.getRGB()) : ""); //$NON-NLS-1$
	}
	//
	//	@XmlTransient
	//	public Color getTableSeatForeColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_FORE_COLOR)) ? Color.BLACK
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_FORE_COLOR)));
	//	}

	public void setTableSeatBGColor(Color seatBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_BG_COLOR, seatBgColor != null ? String.valueOf(seatBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableSeatBGColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_BG_COLOR)) ? Color.ORANGE
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SEAT_BG_COLOR)));
	//	}

	public void setTableServingForeColor(Color servingForeColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_FORE_COLOR, servingForeColor != null ? String.valueOf(servingForeColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableServingForeColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_FORE_COLOR)) ? Color.BLACK
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_FORE_COLOR)));
	//	}

	public void setTableServingBGColor(Color servingBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_BG_COLOR, servingBgColor != null ? String.valueOf(servingBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableServingBGColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_BG_COLOR)) ? new Color(255, 102, 102)
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_SERVING_BG_COLOR)));
	//	}

	public void setTableBookForeColor(Color bookForeColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_FORE_COLOR, bookForeColor != null ? String.valueOf(bookForeColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableBookForeColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_FORE_COLOR)) ? Color.BLACK
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_FORE_COLOR)));
	//	}

	public void setTableBookBGColor(Color bookBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_BG_COLOR, bookBgColor != null ? String.valueOf(bookBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableBookBGColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_BG_COLOR)) ? Color.YELLOW
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_BOOK_BG_COLOR)));
	//	}
	//
	//	public void setTableFreeForeColor(Color freeForeColor) {
	//		addProperty(AppConstants.FLOORPLAN_CONFIG_FREE_FORE_COLOR, freeForeColor != null ? String.valueOf(freeForeColor.getRGB()) : ""); //$NON-NLS-1$
	//	}
	//
	//	@XmlTransient
	//	public Color getTableFreeForeColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_FORE_COLOR)) ? Color.black
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_FORE_COLOR)));
	//	}

	public void setTableFreeBGColor(Color freeBgColor) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_FREE_BG_COLOR, freeBgColor != null ? String.valueOf(freeBgColor.getRGB()) : ""); //$NON-NLS-1$
	}

	//	@XmlTransient
	//	public Color getTableFreeBGColor() {
	//		return StringUtils.isEmpty(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_BG_COLOR)) ? Color.white
	//				: new Color(Integer.parseInt(getProperty(AppConstants.FLOORPLAN_CONFIG_FREE_BG_COLOR)));
	//	}
	//
	//	public boolean isShowTableNameOnTable() {
	//		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NAME, "false")); //$NON-NLS-1$
	//	}
	//
	//	public boolean isShowTableNumberOnTable() {
	//		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NUMBER, "true")); //$NON-NLS-1$
	//	}
	//
	//	public boolean isShowServerNameOnTable() {
	//		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_SERVER_NAME_ON_TABLE, "true")); //$NON-NLS-1$
	//	}
	//
	//	public boolean isShowTokenNumberOnTable() {
	//		return Boolean.valueOf(getProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TOKEN_NUMBER_ON_TABLE, "true")); //$NON-NLS-1$
	//	}

	public void setShowTableNameOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NAME, String.valueOf(show));
	}

	public void setShowTableNumberOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TABLE_NUMBER, String.valueOf(show));
	}

	public void setShowServerNameOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_SERVER_NAME_ON_TABLE, String.valueOf(show));
	}

	public void setShowTokenNumberOnTable(boolean show) {
		addProperty(AppConstants.FLOORPLAN_CONFIG_SHOW_TOKEN_NUMBER_ON_TABLE, String.valueOf(show));
	}

	@Override
	public String getExtraProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getExtraProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setExtraProperties(String properties) {
		super.setExtraProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	public void setDateFormat(String dateFormat) {
		addProperty(AppConstants.PROP_DEFAULT_DATE_FORMAT, dateFormat); //$NON-NLS-1$
	}

	@JsonIgnore
	public String getDateFormat() {
		return getProperty(AppConstants.PROP_DEFAULT_DATE_FORMAT, "dd-MM-yy"); //$NON-NLS-1$
	}

	public void setPickUpAvailable(boolean pickUp) {
		addProperty(AppConstants.PROP_PICKUP, String.valueOf(pickUp));
	}

	@JsonIgnore
	public boolean isPickUpAvailable() {
		return getBooleanProperty(AppConstants.PROP_PICKUP, true);
	}

	@JsonIgnore
	public boolean isDeliveryAvailable() {
		return getBooleanProperty(AppConstants.PROP_DELIVERY, true);
	}

	public void setDeliveryAvailable(boolean delivery) {
		addProperty(AppConstants.PROP_DELIVERY, String.valueOf(delivery));
	}

	@XmlTransient
	@JsonIgnore
	public List<WorkingHours> getWorkingHours() {
		if (workingHours == null) {
			workingHours = new ArrayList<>();
			for (int i = 1; i <= 7; i++) {
				WorkingHours workingHour = getWorkingHours(i);
				if (workingHour == null) {
					continue;
				}
				workingHours.add(workingHour);
			}
		}
		return workingHours;
	}

	public WorkingHours getWorkingHours(int day) {
		/*if (!getBooleanProperty(WorkingHours.days[day] + WorkingHours.OPEN, true)) {
			return null;
		}*/
		return new WorkingHours(day, this);
	}

	public void setWorkingHours(List<WorkingHours> workingHours) {
		this.workingHours = workingHours;
	}

	@XmlTransient
	@JsonIgnore
	public TimeZone getTimeZone() {
		String property = getProperty(WorkingHours.TIME_ZONE);
		if (StringUtils.isBlank(property)) {
			return null;
		}
		return TimeZone.getTimeZone(property);
	}

	@Override
	public void addProperty(String key, String value) {
		this.getPropertyStore().addProperty(key, value);
		setExtraProperties(this.getPropertyStore().toString());
	}

	public void markSetupComplete() {
		addProperty(AppConstants.SETUP_COMPLETE, "true"); //$NON-NLS-1$
	}

	@XmlTransient
	@JsonIgnore
	public boolean isSetupComplete() {
		return getBooleanProperty(AppConstants.SETUP_COMPLETE, false);
	}

	public void setDecimalPlace(String decimalPlace) {
		addProperty(AppConstants.DECIMAL_PLACE, decimalPlace);
	}

	@JsonIgnore
	public int getDecimalPlace() {
		String decimalPlace = getProperty(AppConstants.DECIMAL_PLACE);
		if (StringUtils.isNotBlank(decimalPlace)) {
			try {
				return Integer.parseInt(decimalPlace);
			} catch (Exception e) {
				return 2;
			}
		}
		else {
			return 2;
		}
	}

	@XmlTransient
	@JsonIgnore
	public boolean isEnableAdvanceOrder() {
		return getBooleanProperty("accept_advance_order", false); //$NON-NLS-1$
	}

	public void setEnableAdvanceOrder(Boolean value) {
		addProperty("accept_advance_order", String.valueOf(value)); //$NON-NLS-1$
	}

	public void setCashRoundRule(CashRoundingRule cashRounding) {
		addProperty("cash.rounding.rule", cashRounding.name()); //$NON-NLS-1$
	}

	@JsonIgnore
	public CashRoundingRule getCashRounding() {
		try {
			String property = getProperty("cash.rounding.rule"); //$NON-NLS-1$
			if (StringUtils.isBlank(property)) {
				return CashRoundingRule._NOROUNDING;
			}

			return CashRoundingRule.valueOf(property);
		} catch (Exception e) {
			return CashRoundingRule._NOROUNDING;
		}
	}

	@JsonIgnore
	public double getOvertimeMarkup() {
		try {
			String overtimeMarkup = getProperty(AppConstants.STORE_OVERTIME_MARKUP);
			if (StringUtils.isNotEmpty(overtimeMarkup)) {
				return NumberUtil.parseDouble(overtimeMarkup);
			}

		} catch (Exception e) {
		}
		return 0.0;
	}

	@JsonIgnore
	public Integer getDefaultPinLength() {
		return getIntProperty("poslive.default_pin.length"); //$NON-NLS-1$
	}

	public void setDefaultPinLength(String defaultPinLength) {
		addProperty("poslive.default_pin.length", defaultPinLength); //$NON-NLS-1$
	}

	public String getWebsiteAddress() {
		return getProperty("medlogics.website.address ", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putWebsiteAddress(String websiteAddress) {
		addProperty("medlogics.website.address ", websiteAddress); //$NON-NLS-1$
	}

	public int getLabStickerWitdh() {
		return POSUtil.parseInteger(getProperty("lab_sticker_width", "300"));
	}

	public void putLabStickerWitdh(String width) {
		addProperty("lab_sticker_width", width); //$NON-NLS-1$
	}

	public int getLabStickerHeight() {
		return POSUtil.parseInteger(getProperty("lab_sticker_height", "300"));
	}

	public void putLabStickerHeight(String height) {
		addProperty("lab_sticker_height", height); //$NON-NLS-1$
	}

	public int getReportHeaderMargin() {
		return POSUtil.parseInteger(getProperty("report_header_margin", "0"));
	}

	public void putReportHeaderMargin(String margin) {
		addProperty("report_header_margin", margin); //$NON-NLS-1$
	}

	public int getReportFooterMargin() {
		return POSUtil.parseInteger(getProperty("report_footer_margin", "0"));
	}

	public void putReportFooterMargin(String marging) {
		addProperty("report_footer_margin", marging); //$NON-NLS-1$
	}

	public int getReceiptReportHeaderMargin() {
		return POSUtil.parseInteger(getProperty("receipt_report_header_margin", "0"));
	}

	public void putReceiptReportHeaderMargin(String margin) {
		addProperty("receipt_report_header_margin", margin); //$NON-NLS-1$
	}

	public int getReceiptReportFooterMargin() {
		return POSUtil.parseInteger(getProperty("receipt_report_footer_margin", "0"));
	}

	public void putReceiptReportFooterMargin(String marging) {
		addProperty("receipt_report_footer_margin", marging); //$NON-NLS-1$
	}

	public int getPharmacyReceiptHeaderMargin() {
		return POSUtil.parseInteger(getProperty("pharmacy_receipt_header_margin", "0")); //$NON-NLS-1$
	}

	public void putPharmacyReceiptHeaderMargin(String margin) {
		addProperty("pharmacy_receipt_header_margin", margin); //$NON-NLS-1$
	}

	public int getPharmacyReceiptFooterMargin() {
		return POSUtil.parseInteger(getProperty("pharmacy_receipt_footer_margin", "0")); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putPharmacyReceiptFooterMargin(String marging) {
		addProperty("pharmacy_receipt_footer_margin", marging); //$NON-NLS-1$
	}

	public void putApplyDiscountOnReferralCommission(boolean apply) {
		addProperty("discount_on_referral_commission", String.valueOf(apply)); //$NON-NLS-1$
	}

	public boolean isApplyDiscountOnReferralCommission() {
		return getBooleanProperty("discount_on_referral_commission", true); //$NON-NLS-1$
	}

	public void putApplyDiscountOnDoctorFee(boolean labDoctorFee) {
		addProperty("discount_on_lab_doctor_fee", String.valueOf(labDoctorFee)); //$NON-NLS-1$
	}

	public boolean isApplyDiscountOnDoctorFee() {
		return getBooleanProperty("discount_on_lab_doctor_fee", false); //$NON-NLS-1$
	}

	public void putShowWelcomeMessageOrLogin(boolean showWelcomeMessageOrLogin) {
		addProperty("donotshow_welcome_dialog", String.valueOf(showWelcomeMessageOrLogin)); //$NON-NLS-1$
	}

	public boolean isShowWelcomeMessageOrLogin() {
		return getBooleanProperty("donotshow_welcome_dialog", false); //$NON-NLS-1$
	}

	public void putShowPrintHeader(boolean reportPrintHeader) {
		addProperty(REPORT_PRINT_HEADER, String.valueOf(reportPrintHeader));
	}

	public boolean isShowReportPrintHeader() {
		return getBooleanProperty(REPORT_PRINT_HEADER, true);
	}

	public void putShowGroupInReport(boolean putPrintGroupInReport) {
		addProperty(PRINT_GROUP_IN_REPORT, String.valueOf(putPrintGroupInReport));
	}

	public boolean isShowGroupInReport() {
		return getBooleanProperty(PRINT_GROUP_IN_REPORT, true);
	}

	public void putShowLabTestFooterInReport(boolean printLabTestFooterInReport) {
		addProperty(PRINT_LAB_TEST_FOOTET_IN_REPORT, String.valueOf(printLabTestFooterInReport));
	}

	public boolean isShowLabTestFooterInReport() {
		return getBooleanProperty(PRINT_LAB_TEST_FOOTET_IN_REPORT, true);
	}

	public void putShowLabTestTechnicianInReport(boolean printLabTestTechnicianInReport) {
		addProperty(PRINT_LAB_TEST_TECHNICIAN_IN_REPORT, String.valueOf(printLabTestTechnicianInReport));
	}

	public boolean isShowLabTestTechnicianInReport() {
		return getBooleanProperty(PRINT_LAB_TEST_TECHNICIAN_IN_REPORT, true);
	}

	public void putShowLabTestInchargeInReport(boolean printLabTestInchargeInReport) {
		addProperty(PRINT_LAB_TEST_INCHARGE_IN_REPORT, String.valueOf(printLabTestInchargeInReport));
	}

	public boolean isShowLabTestInchargeInReport() {
		return getBooleanProperty(PRINT_LAB_TEST_INCHARGE_IN_REPORT, true);
	}

	public void putShowLabDoctorInReport(boolean printLabDoctorInReport) {
		addProperty(PRINT_LAB_DOCTOR_IN_REPORT, String.valueOf(printLabDoctorInReport));
	}

	public boolean isShowLabDoctorInReport() {
		return getBooleanProperty(PRINT_LAB_DOCTOR_IN_REPORT, true);
	}

	public void putReportPaperSize(PaperSize paperSize) {
		addProperty(REPORT_PAPER_SIZE, paperSize.name());
	}

	public PaperSize getReportPaperSize() {
		String paperSize = getProperty(REPORT_PAPER_SIZE, PaperSize.A4.name());
		return PaperSize.fromString(paperSize);
	}

	public void putReceiptPrintHeader(boolean printReceiptPrintHeader) {
		addProperty(RECEIPT_PRINT_HEADER, String.valueOf(printReceiptPrintHeader));
	}

	public boolean isShowReceiptPrintHeader() {
		return getBooleanProperty(RECEIPT_PRINT_HEADER, true);
	}

	public void putPharmacyReceiptPrintHeader(boolean printHeader) {
		addProperty("pharmacy.receipt.print_header", String.valueOf(printHeader)); //$NON-NLS-1$
	}

	public boolean isShowPharmacyReceiptPrintHeader() {
		return getBooleanProperty("pharmacy.receipt.print_header", true); //$NON-NLS-1$
	}

	public void putReceiptPaperSize(PaperSize paperSize) {
		addProperty(RECEIPT_PAPER_SIZE, paperSize.name());
	}

	public PaperSize getReceiptPaperSize() {
		String paperSize = getProperty(RECEIPT_PAPER_SIZE, PaperSize.A4.name());
		return PaperSize.fromString(paperSize);
	}

	//	public String getImagePreview() {
	//		return getProperty(REPORT_IMAGE_PREVIEW, ""); //$NON-NLS-1$
	//	}
	//
	//	public void putImagePreview(String imageId) {
	//		addProperty(REPORT_IMAGE_PREVIEW, imageId);
	//	}
	//
	//	public String getReceiptImagePreview() {
	//		return getProperty("receipt.image_preview", ""); //$NON-NLS-1$ //$NON-NLS-2$
	//	}
	//
	//	public void putReceiptImagePreview(String imageId) {
	//		addProperty("receipt.image_preview", imageId); //$NON-NLS-1$
	//	}
	//
	//	public String getPharmacyImagePreview() {
	//		return getProperty("pharmacy.image_preview", ""); //$NON-NLS-1$ //$NON-NLS-2$
	//	}
	//
	//	public void putPharmacyImagePreview(String imageId) {
	//		addProperty("pharmacy.image_preview", imageId); //$NON-NLS-1$
	//	}

	public void putAutoGenerateInvoiceId(boolean autoGenerateInvoiceId) {
		addProperty("auto_generate_invoice_id", String.valueOf(autoGenerateInvoiceId)); //$NON-NLS-1$
	}

	public boolean isAutoGenerateInvoiceId() {
		return getBooleanProperty("auto_generate_invoice_id", true); //$NON-NLS-1$
	}

	public void putShowSignatureBlockOnPaySlip(boolean isShowSignaturBlockOnPaySlip) {
		addProperty("show_signature_block_on_pay_slip", String.valueOf(isShowSignaturBlockOnPaySlip)); //$NON-NLS-1$
	}

	public boolean isShowSignatureBlockOnPaySlip() {
		return getBooleanProperty("show_signature_block_on_pay_slip", false); //$NON-NLS-1$
	}

	public void putShowSignatureBlockOnPurchaseOrder(boolean isShowSignaturBlockOnPaySlip) {
		addProperty("show_signature_block_on_purchase_order", String.valueOf(isShowSignaturBlockOnPaySlip)); //$NON-NLS-1$
	}

	public boolean isShowSignatureBlockOnPurchaseOrder() {
		return getBooleanProperty("show_signature_block_on_purchase_order", false); //$NON-NLS-1$
	}

	public void putRemoveSeparatorLines(boolean removeSepartorLine) {
		addProperty("remove_separator_line", String.valueOf(removeSepartorLine)); //$NON-NLS-1$
	}

	public boolean isRemoveSeparatorLines() {
		return getBooleanProperty("remove_separator_line", false); //$NON-NLS-1$
	}

	public void putGroupLabTestByCategory(boolean receiptGroupCategory) {
		addProperty("group_lab_test_by_category", String.valueOf(receiptGroupCategory)); //$NON-NLS-1$
	}

	public boolean isShowGroupLabTestByCategory() {
		return getBooleanProperty("group_lab_test_by_category", false); //$NON-NLS-1$
	}

	public void putShowPathologyTestRoomNo(boolean showPathologyTestRoomNo) {
		addProperty("show_pathology_test_room_no", String.valueOf(showPathologyTestRoomNo)); //$NON-NLS-1$
	}

	public boolean isShowPathologyTestRoomNo() {
		return getBooleanProperty("show_pathology_test_room_no", true); //$NON-NLS-1$
	}

	public void putShowCategoryTotal(boolean showCategoryTotal) {
		addProperty("show_category_total", String.valueOf(showCategoryTotal)); //$NON-NLS-1$
	}

	public boolean isShowCategoryTotal() {
		return getBooleanProperty("show_category_total", false); //$NON-NLS-1$
	}

	public void putShowLabDoctorSampleCollectionWindow(boolean showLabDoctorSampleCollectionWindow) {
		addProperty("show_labdoctor_sample_collection_window", String.valueOf(showLabDoctorSampleCollectionWindow)); //$NON-NLS-1$
	}

	public boolean isShowLabDoctorSampleCollectionWindow() {
		return getBooleanProperty("show_labdoctor_sample_collection_window", true); //$NON-NLS-1$
	}

	public void putShowContainerSampleCollectionWindow(boolean showContainerSampleCollectionWindow) {
		addProperty("show_container_sample_collection_window", String.valueOf(showContainerSampleCollectionWindow)); //$NON-NLS-1$
	}

	public boolean isShowContainerSampleCollectionWindow() {
		return getBooleanProperty("show_container_sample_collection_window", true); //$NON-NLS-1$
	}

	public void putAllowPriceInputOnSalesScreen(boolean allowPriceInputOnSalesScreen) {
		addProperty("allowPriceInputOnSalesScreen", String.valueOf(allowPriceInputOnSalesScreen)); //$NON-NLS-1$
	}

	public boolean isAllowPriceInputOnSalesScreen() {
		return getBooleanProperty("allowPriceInputOnSalesScreen", false); //$NON-NLS-1$
	}

	public void putPharmacyReceiptPaperSize(PaperSize paperSize) {
		addProperty("pharmacy.receipt.paper_size", paperSize.name()); //$NON-NLS-1$
	}

	public PaperSize getPharmacyReceiptPaperSize() {
		String paperSize = getProperty("pharmacy.receipt.paper_size", PaperSize.EIGHTY.name()); //$NON-NLS-1$
		return PaperSize.fromString(paperSize);
	}

	public void putGroupProductsByCategory(boolean showGroupsByCategory) {
		addProperty("group_products_by_category", String.valueOf(showGroupsByCategory)); //$NON-NLS-1$
	}

	public boolean isGroupProductsByCategory() {
		return getBooleanProperty("group_products_by_category", false); //$NON-NLS-1$
	}

	public void putPrintReceiptStoreLogo(boolean printStoreLogo) {
		addProperty("print_receipt_store_logo", String.valueOf(printStoreLogo)); //$NON-NLS-1$
	}

	public boolean isShowPrintReceiptStoreLogo() {
		return getBooleanProperty("print_receipt_store_logo", false); //$NON-NLS-1$
	}

	public void putPharmacyReceiptStoreLogo(boolean printStoreLogo) {
		addProperty("pharmacy_receipt_store_logo", String.valueOf(printStoreLogo)); //$NON-NLS-1$
	}

	public boolean isShowPharmacyReceiptStoreLogo() {
		return getBooleanProperty("pharmacy_receipt_store_logo", false); //$NON-NLS-1$
	}

	public void putPrintReportStoreLogo(boolean printStoreLogo) {
		addProperty("print_report_store_logo", String.valueOf(printStoreLogo)); //$NON-NLS-1$
	}

	public boolean isShowPrintReportStoreLogo() {
		return getBooleanProperty("print_report_store_logo", false); //$NON-NLS-1$
	}

	public void putShowInvoiceSampleId(boolean sampleId) {
		addProperty("show_invoice_sampleid", String.valueOf(sampleId)); //$NON-NLS-1$
	}

	public boolean isShowInvoiceSampleId() {
		return getBooleanProperty("show_invoice_sampleid", false); //$NON-NLS-1$
	}

	public void putAutoCloseRegisterOnLogout(boolean autoCloseRegisterOnLogout) {
		addProperty("auto_close_register_on_logout", String.valueOf(autoCloseRegisterOnLogout)); //$NON-NLS-1$
	}

	public boolean isAutoCloseRegisterOnLogout() {
		return getBooleanProperty("auto_close_register_on_logout", true); //$NON-NLS-1$
	}

	public boolean isBengaliFontOnLabReport() {
		return getBooleanProperty("bengali_font_on_lab_report", false); //$NON-NLS-1$
	}

	public void putBengaliFontOnLabReport(boolean bengaliFontOnLabReport) {
		addProperty("bengali_font_on_lab_report", String.valueOf(bengaliFontOnLabReport)); //$NON-NLS-1$
	}

	public boolean isEnableJasperPrint() {
		return getBooleanProperty("enable_jasper_print", true); //$NON-NLS-1$
	}

	public void putEnableJasperPrint(boolean enableJasperPrint) {
		addProperty("enable_jasper_print", String.valueOf(enableJasperPrint)); //$NON-NLS-1$
	}

	public void putShowReportsInBangla(boolean showReportsInBangla) {
		addProperty("show_reports_in_bangla", String.valueOf(showReportsInBangla)); //$NON-NLS-1$
	}

	public Boolean isShowReportsInBangla() {
		return getBooleanProperty("show_reports_in_bangla", false); //$NON-NLS-1$
	}

	public void putShowPadImageInReport(boolean showPadImage) {
		addProperty("show_pad_image_in_report", String.valueOf(showPadImage)); //$NON-NLS-1$
	}

	public Boolean isShowPadImageInReport() {
		return getBooleanProperty("show_pad_image_in_report", false); //$NON-NLS-1$
	}

	public void putShowPadImageInReceipt(boolean showPadImage) {
		addProperty("show_pad_image_in_receipt", String.valueOf(showPadImage)); //$NON-NLS-1$
	}

	public Boolean isShowPadImageInReceipt() {
		return getBooleanProperty("show_pad_image_in_receipt", false); //$NON-NLS-1$
	}

	public void putShowPadImageInPharmacy(boolean showPadImage) {
		addProperty("show_pad_image_in_pharmacy", String.valueOf(showPadImage)); //$NON-NLS-1$
	}

	public Boolean isShowPadImageInPharmacy() {
		return getBooleanProperty("show_pad_image_in_pharmacy", false); //$NON-NLS-1$
	}

	@XmlTransient
	@JsonIgnore
	public List<RecepieItem> getDefaultAdmissionItems() {
		List<RecepieItem> admissionItems = new ArrayList<>();
		JsonObject jsonProperties = this.getPropertyStore();
		if (jsonProperties == null || !jsonProperties.has("defaultAdmissionItems")) { //$NON-NLS-1$
			return admissionItems;
		}
		JsonArray jsonArray = jsonProperties.getAsJsonArray("defaultAdmissionItems"); //$NON-NLS-1$
		for (int i = 0; i < jsonArray.size(); i++) {
			JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
			RecepieItem admissionItem = new RecepieItem();
			String itemId = OrgJsonUtil.getString(jsonObject, RecepieItem.PROP_INVENTORY_ITEM);
			if (StringUtils.isBlank(itemId)) {
				continue;
			}
			MenuItem item = MenuItemDAO.getInstance().get(itemId);
			if (item == null) {
				continue;
			}
			admissionItem.setInventoryItem(item);
			admissionItem.setQuantity(OrgJsonUtil.getDouble(jsonObject, RecepieItem.PROP_QUANTITY));
			admissionItem.setUnitCode(OrgJsonUtil.getString(jsonObject, RecepieItem.PROP_UNIT_CODE));
			admissionItems.add(admissionItem);
		}
		return admissionItems;
	}

	public void setDefaultAdmissionItems(List<RecepieItem> admissionItems) {
		if (admissionItems == null) {
			admissionItems = new ArrayList<>();
		}
		JsonArray admissionItemsArray = new JsonArray();
		for (RecepieItem admissionItem : admissionItems) {
			JsonObject jsonObject = new JsonObject();
			jsonObject.addProperty(RecepieItem.PROP_INVENTORY_ITEM, admissionItem.getInventoryItem().getId());
			jsonObject.addProperty(RecepieItem.PROP_QUANTITY, admissionItem.getQuantity());
			jsonObject.addProperty(RecepieItem.PROP_UNIT_CODE, admissionItem.getUnitCode());
			admissionItemsArray.add(jsonObject);
		}
		getPropertyStore().add("defaultAdmissionItems", admissionItemsArray); //$NON-NLS-1$
	}

	public void putDefaultAdmissionCharge(double defaultAdmissionCharge) {
		addProperty("defaultAdmissionCharge", NumberUtil.format(defaultAdmissionCharge)); //$NON-NLS-1$
	}

	public double getDefaultAdmissionCharge() {
		return getDoubleProperty("defaultAdmissionCharge"); //$NON-NLS-1$
	}

	public void putMinimumAdvanceAmount(double minimumAdvanceAmount) {
		addProperty("minimumAdvanceAmount", NumberUtil.format(minimumAdvanceAmount)); //$NON-NLS-1$
	}

	public double getMinimumAdvanceAmount() {
		return getDoubleProperty("minimumAdvanceAmount"); //$NON-NLS-1$
	}

	@XmlTransient
	@JsonIgnore
	public List<RecepieItem> getAdditionalOTItems() {
		List<RecepieItem> otItems = new ArrayList<>();
		JsonObject jsonProperties = this.getPropertyStore();
		if (jsonProperties == null || !jsonProperties.has("additionalOTItems")) { //$NON-NLS-1$
			return otItems;
		}
		JsonArray jsonArray = jsonProperties.getAsJsonArray("additionalOTItems"); //$NON-NLS-1$
		for (int i = 0; i < jsonArray.size(); i++) {
			JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
			RecepieItem admissionItem = new RecepieItem();
			String itemId = OrgJsonUtil.getString(jsonObject, RecepieItem.PROP_INVENTORY_ITEM);
			if (StringUtils.isBlank(itemId)) {
				continue;
			}
			MenuItem item = MenuItemDAO.getInstance().get(itemId);
			if (item == null) {
				continue;
			}
			admissionItem.setInventoryItem(item);
			admissionItem.setQuantity(OrgJsonUtil.getDouble(jsonObject, RecepieItem.PROP_QUANTITY));
			admissionItem.setUnitCode(OrgJsonUtil.getString(jsonObject, RecepieItem.PROP_UNIT_CODE));
			otItems.add(admissionItem);
		}
		return otItems;
	}

	public void setAdditionalOTItems(List<RecepieItem> otItems) {
		if (otItems == null) {
			otItems = new ArrayList<>();
		}
		JsonArray otItemsArray = new JsonArray();
		for (RecepieItem otItem : otItems) {
			JsonObject jsonObject = new JsonObject();
			jsonObject.addProperty(RecepieItem.PROP_INVENTORY_ITEM, otItem.getInventoryItem().getId());
			jsonObject.addProperty(RecepieItem.PROP_QUANTITY, otItem.getQuantity());
			jsonObject.addProperty(RecepieItem.PROP_UNIT_CODE, otItem.getUnitCode());
			otItemsArray.add(jsonObject);
		}
		getPropertyStore().add("additionalOTItems", otItemsArray); //$NON-NLS-1$
	}

	public void putBedChangeChargeTime(int time) {
		addProperty("bed_change_time_interval", String.valueOf(time)); //$NON-NLS-1$
	}

	public int getBedChangeChargeTime() {
		return getIntProperty("bed_change_time_interval"); //$NON-NLS-1$
	}

	public void putAdmissionTime(String admissionTime) {
		addProperty("admission_time", admissionTime); //$NON-NLS-1$
	}

	public String getAdmissionTime() {
		return getProperty("admission_time", "11:00 AM"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putDischargeTime(String dischargeTime) {
		addProperty("discharge_time", dischargeTime); //$NON-NLS-1$
	}

	public String getDischargeTime() {
		return getProperty("discharge_time", "12:00 PM"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public Date parseAndGetAdmissionTime() {
		try {
			return new SimpleDateFormat("hh:mm a").parse(getAdmissionTime()); //$NON-NLS-1$
		} catch (ParseException e) {
		}
		return null;
	}

	public Date parseAndGetDischargeTime() {
		try {
			return new SimpleDateFormat("hh:mm a").parse(getDischargeTime()); //$NON-NLS-1$
		} catch (ParseException e) {
		}
		return null;
	}

	public void putShowCustomerFromAllOutlet(boolean showCustomer) {
		addProperty("show_customer_from_all_outlet", String.valueOf(showCustomer)); //$NON-NLS-1$
	}

	public boolean isShowCustomerFromAllOutlet() {
		return getBooleanProperty("show_customer_from_all_outlet", false); //$NON-NLS-1$
	}

	public boolean isShowPatientSectionOnTop() {
		return getBooleanProperty("show_patient_section_on_top", true); //$NON-NLS-1$
	}

	public void putShowPatientSectionOnTop(boolean b) {
		addProperty("show_patient_section_on_top", String.valueOf(b)); //$NON-NLS-1$
	}

	public void putPrintLabCopy(boolean labCopy) {
		addProperty("print_lab_copy", String.valueOf(labCopy)); //$NON-NLS-1$
	}

	public boolean isPrintLabCopy() {
		return getBooleanProperty("print_lab_copy", true); //$NON-NLS-1$
	}

	public void putPrintPatientCopy(boolean patientCopy) {
		addProperty("print_patient_copy", String.valueOf(patientCopy));
	}

	public boolean isPrintPatientCopy() {
		return getBooleanProperty("print_patient_copy", true);
	}

	public Boolean isShowNetSalesOnDashboard() {
		return getBooleanProperty("dashboard.show_net_sales", true); //$NON-NLS-1$
	}

	public void putShowNetSalesOnDashboard(boolean b) {
		addProperty("dashboard.show_net_sales", String.valueOf(b)); //$NON-NLS-1$
	}

	public Boolean isShowTotalReceiptOnDashboard() {
		return getBooleanProperty("dashboard.show_total_receipt", true); //$NON-NLS-1$
	}

	public void putShowTotalReceiptOnDashboard(boolean b) {
		addProperty("dashboard.show_total_receipt", String.valueOf(b)); //$NON-NLS-1$
	}

	public Boolean isShowNetReceiptOnDashboard() {
		return getBooleanProperty("dashboard.show_net_receipt", true); //$NON-NLS-1$
	}

	public void putShowNetReceiptOnDashboard(boolean b) {
		addProperty("dashboard.show_net_receipt", String.valueOf(b)); //$NON-NLS-1$
	}

	public Boolean isShowDueCollectionOnDashboard() {
		return getBooleanProperty("dashboard.show_due_collection", true); //$NON-NLS-1$
	}

	public void putShowDueCollectionOnDashboard(boolean b) {
		addProperty("dashboard.show_due_collection", String.valueOf(b)); //$NON-NLS-1$
	}

	public Boolean isShowRFPayOnDashboard() {
		return getBooleanProperty("dashboard.show_RF_pay", true); //$NON-NLS-1$
	}

	public void putShowRFPayOnDashboard(boolean b) {
		addProperty("dashboard.show_RF_pay", String.valueOf(b)); //$NON-NLS-1$
	}

	public Boolean isShowLDFPayOnDashboard() {
		return getBooleanProperty("dashboard.show_LDF_pay", true); //$NON-NLS-1$
	}

	public void putShowLDFPayOnDashboard(boolean b) {
		addProperty("dashboard.show_LDF_pay", String.valueOf(b)); //$NON-NLS-1$
	}

	public Boolean isShowDueReceiptOnDashboard() {
		return getBooleanProperty("dashboard.show_due_receipt", true); //$NON-NLS-1$
	}

	public void putShowDueReceiptOnDashboard(boolean b) {
		addProperty("dashboard.show_due_receipt", String.valueOf(b)); //$NON-NLS-1$
	}

	public Boolean isShowTotalItemsOnDashboard() {
		return getBooleanProperty("dashboard.show_total_items", true); //$NON-NLS-1$
	}

	public void putShowTotalItemsOnDashboard(boolean b) {
		addProperty("dashboard.show_total_items", String.valueOf(b)); //$NON-NLS-1$
	}

	public Boolean isShowTotalAdmissionsOnDashboard() {
		return getBooleanProperty("dashboard.show_total_admissions", false); //$NON-NLS-1$
	}

	public void putShowTotalAdmissionsOnDashboard(boolean b) {
		addProperty("dashboard.show_total_admissions", String.valueOf(b)); //$NON-NLS-1$
	}

	public Boolean isShowTotalDischargesOnDashboard() {
		return getBooleanProperty("dashboard.show_total_discharges", false); //$NON-NLS-1$
	}

	public void putShowTotalDischargesOnDashboard(boolean b) {
		addProperty("dashboard.show_total_discharges", String.valueOf(b)); //$NON-NLS-1$
	}

	public Boolean isShowTotalOTOnDashboard() {
		return getBooleanProperty("dashboard.show_total_ot", false); //$NON-NLS-1$
	}

	public void putShowTotalOTOnDashboard(boolean b) {
		addProperty("dashboard.show_total_ot", String.valueOf(b)); //$NON-NLS-1$
	}

	public void putSSLCommerzStoreId(String sslcommerzStoreId) {
		addProperty("sslcommerz.store_id", sslcommerzStoreId); //$NON-NLS-1$
	}

	public Boolean isSSLCommerzConfigured() {
		return hasProperty("sslcommerz.store_id"); //$NON-NLS-1$
	}

	public String getSSLCommerzStoreId() {
		return getProperty("sslcommerz.store_id", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putSSLCommerzStorePass(String sslcommerzStorePass) {
		addProperty("sslcommerz.store_pass", sslcommerzStorePass); //$NON-NLS-1$
	}

	public String getSSLCommerzStorePass() {
		return getProperty("sslcommerz.store_pass", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putSSLCommerzSuccessInstruction(String sslcommerzSuccessInstruction) {
		addProperty("sslcommerz.success_instruction", sslcommerzSuccessInstruction); //$NON-NLS-1$
	}

	public String getSSLCommerzSuccessInstruction() {
		return getProperty("sslcommerz.success_instruction", ""); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putBookingInstruction(String bookingInstruction) {
		addProperty("booking_instruction", bookingInstruction); //$NON-NLS-1$
	}

	public String getBookingInstruction() {
		return getProperty("booking_instruction", "Booking successful. Visit the counter to make your payment and receive your receipt."); //$NON-NLS-1$ //$NON-NLS-2$
	}

	public void putAllowConsolidatedPayment(Boolean allowConsolidatedPayment) {
		addProperty("allow_consolidated_payment", String.valueOf(allowConsolidatedPayment)); //$NON-NLS-1$
	}

	public Boolean isAllowConsolidatedPayment() {
		return getBooleanProperty("allow_consolidated_payment", false); //$NON-NLS-1$
	}

	public OutdoorConfigurationFeeType getOutdoorFeeType() {
		String property = getProperty("outdoor_fee_type"); //$NON-NLS-1$
		return OutdoorConfigurationFeeType.fromName(property);
	}

	public void putOutdoorFeeType(String outdoorFeeType) {
		addProperty("outdoor_fee_type", outdoorFeeType); //$NON-NLS-1$
	}
}